/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Merchant;
import java.util.List;
import java.util.Objects;

public class RetrieveMerchantResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Merchant merchant;

    @JsonCreator
    public RetrieveMerchantResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="merchant") Merchant merchant) {
        this.errors = errors;
        this.merchant = merchant;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="merchant")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Merchant getMerchant() {
        return this.merchant;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.merchant);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveMerchantResponse)) {
            return false;
        }
        RetrieveMerchantResponse other = (RetrieveMerchantResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.merchant, other.merchant);
    }

    public String toString() {
        return "RetrieveMerchantResponse [errors=" + this.errors + ", merchant=" + this.merchant + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).merchant(this.getMerchant());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Merchant merchant;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder merchant(Merchant merchant) {
            this.merchant = merchant;
            return this;
        }

        public RetrieveMerchantResponse build() {
            RetrieveMerchantResponse model = new RetrieveMerchantResponse(this.errors, this.merchant);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

