/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveTokenStatusResponse {
    private HttpContext httpContext;
    private final List<String> scopes;
    private final String expiresAt;
    private final String clientId;
    private final String merchantId;
    private final List<Error> errors;

    @JsonCreator
    public RetrieveTokenStatusResponse(@JsonProperty(value="scopes") List<String> scopes, @JsonProperty(value="expires_at") String expiresAt, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="errors") List<Error> errors) {
        this.scopes = scopes;
        this.expiresAt = expiresAt;
        this.clientId = clientId;
        this.merchantId = merchantId;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="scopes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonGetter(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonGetter(value="client_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.scopes, this.expiresAt, this.clientId, this.merchantId, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveTokenStatusResponse)) {
            return false;
        }
        RetrieveTokenStatusResponse other = (RetrieveTokenStatusResponse)obj;
        return Objects.equals(this.scopes, other.scopes) && Objects.equals(this.expiresAt, other.expiresAt) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RetrieveTokenStatusResponse [scopes=" + this.scopes + ", expiresAt=" + this.expiresAt + ", clientId=" + this.clientId + ", merchantId=" + this.merchantId + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().scopes(this.getScopes()).expiresAt(this.getExpiresAt()).clientId(this.getClientId()).merchantId(this.getMerchantId()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<String> scopes;
        private String expiresAt;
        private String clientId;
        private String merchantId;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RetrieveTokenStatusResponse build() {
            RetrieveTokenStatusResponse model = new RetrieveTokenStatusResponse(this.scopes, this.expiresAt, this.clientId, this.merchantId, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

