/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Transaction;
import java.util.List;
import java.util.Objects;

public class RetrieveTransactionResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Transaction transaction;

    @JsonCreator
    public RetrieveTransactionResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="transaction") Transaction transaction) {
        this.errors = errors;
        this.transaction = transaction;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="transaction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Transaction getTransaction() {
        return this.transaction;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.transaction);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveTransactionResponse)) {
            return false;
        }
        RetrieveTransactionResponse other = (RetrieveTransactionResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.transaction, other.transaction);
    }

    public String toString() {
        return "RetrieveTransactionResponse [errors=" + this.errors + ", transaction=" + this.transaction + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).transaction(this.getTransaction());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Transaction transaction;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder transaction(Transaction transaction) {
            this.transaction = transaction;
            return this;
        }

        public RetrieveTransactionResponse build() {
            RetrieveTransactionResponse model = new RetrieveTransactionResponse(this.errors, this.transaction);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

