/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class RevokeTokenRequest {
    private final OptionalNullable<String> clientId;
    private final OptionalNullable<String> accessToken;
    private final OptionalNullable<String> merchantId;
    private final OptionalNullable<Boolean> revokeOnlyAccessToken;

    @JsonCreator
    public RevokeTokenRequest(@JsonProperty(value="client_id") String clientId, @JsonProperty(value="access_token") String accessToken, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="revoke_only_access_token") Boolean revokeOnlyAccessToken) {
        this.clientId = OptionalNullable.of((Object)clientId);
        this.accessToken = OptionalNullable.of((Object)accessToken);
        this.merchantId = OptionalNullable.of((Object)merchantId);
        this.revokeOnlyAccessToken = OptionalNullable.of((Object)revokeOnlyAccessToken);
    }

    protected RevokeTokenRequest(OptionalNullable<String> clientId, OptionalNullable<String> accessToken, OptionalNullable<String> merchantId, OptionalNullable<Boolean> revokeOnlyAccessToken) {
        this.clientId = clientId;
        this.accessToken = accessToken;
        this.merchantId = merchantId;
        this.revokeOnlyAccessToken = revokeOnlyAccessToken;
    }

    @JsonGetter(value="client_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetClientId() {
        return this.clientId;
    }

    @JsonIgnore
    public String getClientId() {
        return (String)OptionalNullable.getFrom(this.clientId);
    }

    @JsonGetter(value="access_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAccessToken() {
        return this.accessToken;
    }

    @JsonIgnore
    public String getAccessToken() {
        return (String)OptionalNullable.getFrom(this.accessToken);
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMerchantId() {
        return this.merchantId;
    }

    @JsonIgnore
    public String getMerchantId() {
        return (String)OptionalNullable.getFrom(this.merchantId);
    }

    @JsonGetter(value="revoke_only_access_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetRevokeOnlyAccessToken() {
        return this.revokeOnlyAccessToken;
    }

    @JsonIgnore
    public Boolean getRevokeOnlyAccessToken() {
        return (Boolean)OptionalNullable.getFrom(this.revokeOnlyAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.merchantId, this.revokeOnlyAccessToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevokeTokenRequest)) {
            return false;
        }
        RevokeTokenRequest other = (RevokeTokenRequest)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.accessToken, other.accessToken) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.revokeOnlyAccessToken, other.revokeOnlyAccessToken);
    }

    public String toString() {
        return "RevokeTokenRequest [clientId=" + this.clientId + ", accessToken=" + this.accessToken + ", merchantId=" + this.merchantId + ", revokeOnlyAccessToken=" + this.revokeOnlyAccessToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.clientId = this.internalGetClientId();
        builder.accessToken = this.internalGetAccessToken();
        builder.merchantId = this.internalGetMerchantId();
        builder.revokeOnlyAccessToken = this.internalGetRevokeOnlyAccessToken();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> clientId;
        private OptionalNullable<String> accessToken;
        private OptionalNullable<String> merchantId;
        private OptionalNullable<Boolean> revokeOnlyAccessToken;

        public Builder clientId(String clientId) {
            this.clientId = OptionalNullable.of((Object)clientId);
            return this;
        }

        public Builder unsetClientId() {
            this.clientId = null;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = OptionalNullable.of((Object)accessToken);
            return this;
        }

        public Builder unsetAccessToken() {
            this.accessToken = null;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = OptionalNullable.of((Object)merchantId);
            return this;
        }

        public Builder unsetMerchantId() {
            this.merchantId = null;
            return this;
        }

        public Builder revokeOnlyAccessToken(Boolean revokeOnlyAccessToken) {
            this.revokeOnlyAccessToken = OptionalNullable.of((Object)revokeOnlyAccessToken);
            return this;
        }

        public Builder unsetRevokeOnlyAccessToken() {
            this.revokeOnlyAccessToken = null;
            return this;
        }

        public RevokeTokenRequest build() {
            return new RevokeTokenRequest(this.clientId, this.accessToken, this.merchantId, this.revokeOnlyAccessToken);
        }
    }
}

