/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RiskEvaluation {
    private final String createdAt;
    private final String riskLevel;

    @JsonCreator
    public RiskEvaluation(@JsonProperty(value="created_at") String createdAt, @JsonProperty(value="risk_level") String riskLevel) {
        this.createdAt = createdAt;
        this.riskLevel = riskLevel;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="risk_level")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRiskLevel() {
        return this.riskLevel;
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.riskLevel);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RiskEvaluation)) {
            return false;
        }
        RiskEvaluation other = (RiskEvaluation)obj;
        return Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.riskLevel, other.riskLevel);
    }

    public String toString() {
        return "RiskEvaluation [createdAt=" + this.createdAt + ", riskLevel=" + this.riskLevel + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().createdAt(this.getCreatedAt()).riskLevel(this.getRiskLevel());
        return builder;
    }

    public static class Builder {
        private String createdAt;
        private String riskLevel;

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder riskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
            return this;
        }

        public RiskEvaluation build() {
            return new RiskEvaluation(this.createdAt, this.riskLevel);
        }
    }
}

