/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.SegmentFilter;
import com.squareup.square.models.TimeRange;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SearchAvailabilityFilter {
    private final TimeRange startAtRange;
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<List<SegmentFilter>> segmentFilters;
    private final OptionalNullable<String> bookingId;

    @JsonCreator
    public SearchAvailabilityFilter(@JsonProperty(value="start_at_range") TimeRange startAtRange, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="segment_filters") List<SegmentFilter> segmentFilters, @JsonProperty(value="booking_id") String bookingId) {
        this.startAtRange = startAtRange;
        this.locationId = OptionalNullable.of((Object)locationId);
        this.segmentFilters = OptionalNullable.of(segmentFilters);
        this.bookingId = OptionalNullable.of((Object)bookingId);
    }

    protected SearchAvailabilityFilter(TimeRange startAtRange, OptionalNullable<String> locationId, OptionalNullable<List<SegmentFilter>> segmentFilters, OptionalNullable<String> bookingId) {
        this.startAtRange = startAtRange;
        this.locationId = locationId;
        this.segmentFilters = segmentFilters;
        this.bookingId = bookingId;
    }

    @JsonGetter(value="start_at_range")
    public TimeRange getStartAtRange() {
        return this.startAtRange;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="segment_filters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<SegmentFilter>> internalGetSegmentFilters() {
        return this.segmentFilters;
    }

    @JsonIgnore
    public List<SegmentFilter> getSegmentFilters() {
        return (List)OptionalNullable.getFrom(this.segmentFilters);
    }

    @JsonGetter(value="booking_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBookingId() {
        return this.bookingId;
    }

    @JsonIgnore
    public String getBookingId() {
        return (String)OptionalNullable.getFrom(this.bookingId);
    }

    public int hashCode() {
        return Objects.hash(this.startAtRange, this.locationId, this.segmentFilters, this.bookingId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchAvailabilityFilter)) {
            return false;
        }
        SearchAvailabilityFilter other = (SearchAvailabilityFilter)obj;
        return Objects.equals(this.startAtRange, other.startAtRange) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.segmentFilters, other.segmentFilters) && Objects.equals(this.bookingId, other.bookingId);
    }

    public String toString() {
        return "SearchAvailabilityFilter [startAtRange=" + this.startAtRange + ", locationId=" + this.locationId + ", segmentFilters=" + this.segmentFilters + ", bookingId=" + this.bookingId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.startAtRange);
        builder.locationId = this.internalGetLocationId();
        builder.segmentFilters = this.internalGetSegmentFilters();
        builder.bookingId = this.internalGetBookingId();
        return builder;
    }

    public static class Builder {
        private TimeRange startAtRange;
        private OptionalNullable<String> locationId;
        private OptionalNullable<List<SegmentFilter>> segmentFilters;
        private OptionalNullable<String> bookingId;

        public Builder(TimeRange startAtRange) {
            this.startAtRange = startAtRange;
        }

        public Builder startAtRange(TimeRange startAtRange) {
            this.startAtRange = startAtRange;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder segmentFilters(List<SegmentFilter> segmentFilters) {
            this.segmentFilters = OptionalNullable.of(segmentFilters);
            return this;
        }

        public Builder unsetSegmentFilters() {
            this.segmentFilters = null;
            return this;
        }

        public Builder bookingId(String bookingId) {
            this.bookingId = OptionalNullable.of((Object)bookingId);
            return this;
        }

        public Builder unsetBookingId() {
            this.bookingId = null;
            return this;
        }

        public SearchAvailabilityFilter build() {
            return new SearchAvailabilityFilter(this.startAtRange, this.locationId, this.segmentFilters, this.bookingId);
        }
    }
}

