/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class SearchCatalogItemsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<CatalogObject> items;
    private final String cursor;
    private final List<String> matchedVariationIds;

    @JsonCreator
    public SearchCatalogItemsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="items") List<CatalogObject> items, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="matched_variation_ids") List<String> matchedVariationIds) {
        this.errors = errors;
        this.items = items;
        this.cursor = cursor;
        this.matchedVariationIds = matchedVariationIds;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getItems() {
        return this.items;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="matched_variation_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getMatchedVariationIds() {
        return this.matchedVariationIds;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.items, this.cursor, this.matchedVariationIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCatalogItemsResponse)) {
            return false;
        }
        SearchCatalogItemsResponse other = (SearchCatalogItemsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.items, other.items) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.matchedVariationIds, other.matchedVariationIds);
    }

    public String toString() {
        return "SearchCatalogItemsResponse [errors=" + this.errors + ", items=" + this.items + ", cursor=" + this.cursor + ", matchedVariationIds=" + this.matchedVariationIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).items(this.getItems()).cursor(this.getCursor()).matchedVariationIds(this.getMatchedVariationIds());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<CatalogObject> items;
        private String cursor;
        private List<String> matchedVariationIds;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder items(List<CatalogObject> items) {
            this.items = items;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder matchedVariationIds(List<String> matchedVariationIds) {
            this.matchedVariationIds = matchedVariationIds;
            return this;
        }

        public SearchCatalogItemsResponse build() {
            SearchCatalogItemsResponse model = new SearchCatalogItemsResponse(this.errors, this.items, this.cursor, this.matchedVariationIds);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

