/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class SearchCatalogObjectsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final String cursor;
    private final List<CatalogObject> objects;
    private final List<CatalogObject> relatedObjects;
    private final String latestTime;

    @JsonCreator
    public SearchCatalogObjectsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="objects") List<CatalogObject> objects, @JsonProperty(value="related_objects") List<CatalogObject> relatedObjects, @JsonProperty(value="latest_time") String latestTime) {
        this.errors = errors;
        this.cursor = cursor;
        this.objects = objects;
        this.relatedObjects = relatedObjects;
        this.latestTime = latestTime;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    @JsonGetter(value="related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getRelatedObjects() {
        return this.relatedObjects;
    }

    @JsonGetter(value="latest_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLatestTime() {
        return this.latestTime;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.cursor, this.objects, this.relatedObjects, this.latestTime);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCatalogObjectsResponse)) {
            return false;
        }
        SearchCatalogObjectsResponse other = (SearchCatalogObjectsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.objects, other.objects) && Objects.equals(this.relatedObjects, other.relatedObjects) && Objects.equals(this.latestTime, other.latestTime);
    }

    public String toString() {
        return "SearchCatalogObjectsResponse [errors=" + this.errors + ", cursor=" + this.cursor + ", objects=" + this.objects + ", relatedObjects=" + this.relatedObjects + ", latestTime=" + this.latestTime + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).cursor(this.getCursor()).objects(this.getObjects()).relatedObjects(this.getRelatedObjects()).latestTime(this.getLatestTime());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private String cursor;
        private List<CatalogObject> objects;
        private List<CatalogObject> relatedObjects;
        private String latestTime;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = objects;
            return this;
        }

        public Builder relatedObjects(List<CatalogObject> relatedObjects) {
            this.relatedObjects = relatedObjects;
            return this;
        }

        public Builder latestTime(String latestTime) {
            this.latestTime = latestTime;
            return this;
        }

        public SearchCatalogObjectsResponse build() {
            SearchCatalogObjectsResponse model = new SearchCatalogObjectsResponse(this.errors, this.cursor, this.objects, this.relatedObjects, this.latestTime);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

