/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.LoyaltyAccountMapping;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SearchLoyaltyAccountsRequestLoyaltyAccountQuery {
    private final OptionalNullable<List<LoyaltyAccountMapping>> mappings;
    private final OptionalNullable<List<String>> customerIds;

    @JsonCreator
    public SearchLoyaltyAccountsRequestLoyaltyAccountQuery(@JsonProperty(value="mappings") List<LoyaltyAccountMapping> mappings, @JsonProperty(value="customer_ids") List<String> customerIds) {
        this.mappings = OptionalNullable.of(mappings);
        this.customerIds = OptionalNullable.of(customerIds);
    }

    protected SearchLoyaltyAccountsRequestLoyaltyAccountQuery(OptionalNullable<List<LoyaltyAccountMapping>> mappings, OptionalNullable<List<String>> customerIds) {
        this.mappings = mappings;
        this.customerIds = customerIds;
    }

    @JsonGetter(value="mappings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<LoyaltyAccountMapping>> internalGetMappings() {
        return this.mappings;
    }

    @JsonIgnore
    public List<LoyaltyAccountMapping> getMappings() {
        return (List)OptionalNullable.getFrom(this.mappings);
    }

    @JsonGetter(value="customer_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetCustomerIds() {
        return this.customerIds;
    }

    @JsonIgnore
    public List<String> getCustomerIds() {
        return (List)OptionalNullable.getFrom(this.customerIds);
    }

    public int hashCode() {
        return Objects.hash(this.mappings, this.customerIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchLoyaltyAccountsRequestLoyaltyAccountQuery)) {
            return false;
        }
        SearchLoyaltyAccountsRequestLoyaltyAccountQuery other = (SearchLoyaltyAccountsRequestLoyaltyAccountQuery)obj;
        return Objects.equals(this.mappings, other.mappings) && Objects.equals(this.customerIds, other.customerIds);
    }

    public String toString() {
        return "SearchLoyaltyAccountsRequestLoyaltyAccountQuery [mappings=" + this.mappings + ", customerIds=" + this.customerIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.mappings = this.internalGetMappings();
        builder.customerIds = this.internalGetCustomerIds();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<LoyaltyAccountMapping>> mappings;
        private OptionalNullable<List<String>> customerIds;

        public Builder mappings(List<LoyaltyAccountMapping> mappings) {
            this.mappings = OptionalNullable.of(mappings);
            return this;
        }

        public Builder unsetMappings() {
            this.mappings = null;
            return this;
        }

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = OptionalNullable.of(customerIds);
            return this;
        }

        public Builder unsetCustomerIds() {
            this.customerIds = null;
            return this;
        }

        public SearchLoyaltyAccountsRequestLoyaltyAccountQuery build() {
            return new SearchLoyaltyAccountsRequestLoyaltyAccountQuery(this.mappings, this.customerIds);
        }
    }
}

