/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SearchOrdersCustomerFilter {
    private final OptionalNullable<List<String>> customerIds;

    @JsonCreator
    public SearchOrdersCustomerFilter(@JsonProperty(value="customer_ids") List<String> customerIds) {
        this.customerIds = OptionalNullable.of(customerIds);
    }

    protected SearchOrdersCustomerFilter(OptionalNullable<List<String>> customerIds) {
        this.customerIds = customerIds;
    }

    @JsonGetter(value="customer_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetCustomerIds() {
        return this.customerIds;
    }

    @JsonIgnore
    public List<String> getCustomerIds() {
        return (List)OptionalNullable.getFrom(this.customerIds);
    }

    public int hashCode() {
        return Objects.hash(this.customerIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersCustomerFilter)) {
            return false;
        }
        SearchOrdersCustomerFilter other = (SearchOrdersCustomerFilter)obj;
        return Objects.equals(this.customerIds, other.customerIds);
    }

    public String toString() {
        return "SearchOrdersCustomerFilter [customerIds=" + this.customerIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.customerIds = this.internalGetCustomerIds();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> customerIds;

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = OptionalNullable.of(customerIds);
            return this;
        }

        public Builder unsetCustomerIds() {
            this.customerIds = null;
            return this;
        }

        public SearchOrdersCustomerFilter build() {
            return new SearchOrdersCustomerFilter(this.customerIds);
        }
    }
}

