/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SearchOrdersQuery;
import java.util.List;
import java.util.Objects;

public class SearchOrdersRequest {
    private final List<String> locationIds;
    private final String cursor;
    private final SearchOrdersQuery query;
    private final Integer limit;
    private final Boolean returnEntries;

    @JsonCreator
    public SearchOrdersRequest(@JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="query") SearchOrdersQuery query, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="return_entries") Boolean returnEntries) {
        this.locationIds = locationIds;
        this.cursor = cursor;
        this.query = query;
        this.limit = limit;
        this.returnEntries = returnEntries;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersQuery getQuery() {
        return this.query;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="return_entries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getReturnEntries() {
        return this.returnEntries;
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.cursor, this.query, this.limit, this.returnEntries);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersRequest)) {
            return false;
        }
        SearchOrdersRequest other = (SearchOrdersRequest)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.returnEntries, other.returnEntries);
    }

    public String toString() {
        return "SearchOrdersRequest [locationIds=" + this.locationIds + ", cursor=" + this.cursor + ", query=" + this.query + ", limit=" + this.limit + ", returnEntries=" + this.returnEntries + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationIds(this.getLocationIds()).cursor(this.getCursor()).query(this.getQuery()).limit(this.getLimit()).returnEntries(this.getReturnEntries());
        return builder;
    }

    public static class Builder {
        private List<String> locationIds;
        private String cursor;
        private SearchOrdersQuery query;
        private Integer limit;
        private Boolean returnEntries;

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder query(SearchOrdersQuery query) {
            this.query = query;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder returnEntries(Boolean returnEntries) {
            this.returnEntries = returnEntries;
            return this;
        }

        public SearchOrdersRequest build() {
            return new SearchOrdersRequest(this.locationIds, this.cursor, this.query, this.limit, this.returnEntries);
        }
    }
}

