/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SearchSubscriptionsQuery;
import java.util.List;
import java.util.Objects;

public class SearchSubscriptionsRequest {
    private final String cursor;
    private final Integer limit;
    private final SearchSubscriptionsQuery query;
    private final List<String> include;

    @JsonCreator
    public SearchSubscriptionsRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="query") SearchSubscriptionsQuery query, @JsonProperty(value="include") List<String> include) {
        this.cursor = cursor;
        this.limit = limit;
        this.query = query;
        this.include = include;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchSubscriptionsQuery getQuery() {
        return this.query;
    }

    @JsonGetter(value="include")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getInclude() {
        return this.include;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.query, this.include);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchSubscriptionsRequest)) {
            return false;
        }
        SearchSubscriptionsRequest other = (SearchSubscriptionsRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.query, other.query) && Objects.equals(this.include, other.include);
    }

    public String toString() {
        return "SearchSubscriptionsRequest [cursor=" + this.cursor + ", limit=" + this.limit + ", query=" + this.query + ", include=" + this.include + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).limit(this.getLimit()).query(this.getQuery()).include(this.getInclude());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private Integer limit;
        private SearchSubscriptionsQuery query;
        private List<String> include;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder query(SearchSubscriptionsQuery query) {
            this.query = query;
            return this;
        }

        public Builder include(List<String> include) {
            this.include = include;
            return this;
        }

        public SearchSubscriptionsRequest build() {
            return new SearchSubscriptionsRequest(this.cursor, this.limit, this.query, this.include);
        }
    }
}

