/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SearchTeamMembersFilter {
    private final OptionalNullable<List<String>> locationIds;
    private final String status;
    private final OptionalNullable<Boolean> isOwner;

    @JsonCreator
    public SearchTeamMembersFilter(@JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="status") String status, @JsonProperty(value="is_owner") Boolean isOwner) {
        this.locationIds = OptionalNullable.of(locationIds);
        this.status = status;
        this.isOwner = OptionalNullable.of((Object)isOwner);
    }

    protected SearchTeamMembersFilter(OptionalNullable<List<String>> locationIds, String status, OptionalNullable<Boolean> isOwner) {
        this.locationIds = locationIds;
        this.status = status;
        this.isOwner = isOwner;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public List<String> getLocationIds() {
        return (List)OptionalNullable.getFrom(this.locationIds);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="is_owner")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsOwner() {
        return this.isOwner;
    }

    @JsonIgnore
    public Boolean getIsOwner() {
        return (Boolean)OptionalNullable.getFrom(this.isOwner);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.status, this.isOwner);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTeamMembersFilter)) {
            return false;
        }
        SearchTeamMembersFilter other = (SearchTeamMembersFilter)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.status, other.status) && Objects.equals(this.isOwner, other.isOwner);
    }

    public String toString() {
        return "SearchTeamMembersFilter [locationIds=" + this.locationIds + ", status=" + this.status + ", isOwner=" + this.isOwner + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().status(this.getStatus());
        builder.locationIds = this.internalGetLocationIds();
        builder.isOwner = this.internalGetIsOwner();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> locationIds;
        private String status;
        private OptionalNullable<Boolean> isOwner;

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = OptionalNullable.of(locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = OptionalNullable.of((Object)isOwner);
            return this;
        }

        public Builder unsetIsOwner() {
            this.isOwner = null;
            return this;
        }

        public SearchTeamMembersFilter build() {
            return new SearchTeamMembersFilter(this.locationIds, this.status, this.isOwner);
        }
    }
}

