/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SelectOption {
    private final String referenceId;
    private final String title;

    @JsonCreator
    public SelectOption(@JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="title") String title) {
        this.referenceId = referenceId;
        this.title = title;
    }

    @JsonGetter(value="reference_id")
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        return Objects.hash(this.referenceId, this.title);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SelectOption)) {
            return false;
        }
        SelectOption other = (SelectOption)obj;
        return Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.title, other.title);
    }

    public String toString() {
        return "SelectOption [referenceId=" + this.referenceId + ", title=" + this.title + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.referenceId, this.title);
        return builder;
    }

    public static class Builder {
        private String referenceId;
        private String title;

        public Builder(String referenceId, String title) {
            this.referenceId = referenceId;
            this.title = title;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public SelectOption build() {
            return new SelectOption(this.referenceId, this.title);
        }
    }
}

