/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.ShiftWorkday;
import com.squareup.square.models.TimeRange;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class ShiftFilter {
    private final OptionalNullable<List<String>> locationIds;
    private final OptionalNullable<List<String>> employeeIds;
    private final String status;
    private final TimeRange start;
    private final TimeRange end;
    private final ShiftWorkday workday;
    private final OptionalNullable<List<String>> teamMemberIds;

    @JsonCreator
    public ShiftFilter(@JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="employee_ids") List<String> employeeIds, @JsonProperty(value="status") String status, @JsonProperty(value="start") TimeRange start, @JsonProperty(value="end") TimeRange end, @JsonProperty(value="workday") ShiftWorkday workday, @JsonProperty(value="team_member_ids") List<String> teamMemberIds) {
        this.locationIds = OptionalNullable.of(locationIds);
        this.employeeIds = OptionalNullable.of(employeeIds);
        this.status = status;
        this.start = start;
        this.end = end;
        this.workday = workday;
        this.teamMemberIds = OptionalNullable.of(teamMemberIds);
    }

    protected ShiftFilter(OptionalNullable<List<String>> locationIds, OptionalNullable<List<String>> employeeIds, String status, TimeRange start, TimeRange end, ShiftWorkday workday, OptionalNullable<List<String>> teamMemberIds) {
        this.locationIds = locationIds;
        this.employeeIds = employeeIds;
        this.status = status;
        this.start = start;
        this.end = end;
        this.workday = workday;
        this.teamMemberIds = teamMemberIds;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public List<String> getLocationIds() {
        return (List)OptionalNullable.getFrom(this.locationIds);
    }

    @JsonGetter(value="employee_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetEmployeeIds() {
        return this.employeeIds;
    }

    @JsonIgnore
    public List<String> getEmployeeIds() {
        return (List)OptionalNullable.getFrom(this.employeeIds);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="start")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getStart() {
        return this.start;
    }

    @JsonGetter(value="end")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getEnd() {
        return this.end;
    }

    @JsonGetter(value="workday")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShiftWorkday getWorkday() {
        return this.workday;
    }

    @JsonGetter(value="team_member_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetTeamMemberIds() {
        return this.teamMemberIds;
    }

    @JsonIgnore
    public List<String> getTeamMemberIds() {
        return (List)OptionalNullable.getFrom(this.teamMemberIds);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.employeeIds, this.status, this.start, this.end, this.workday, this.teamMemberIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShiftFilter)) {
            return false;
        }
        ShiftFilter other = (ShiftFilter)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.employeeIds, other.employeeIds) && Objects.equals(this.status, other.status) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.workday, other.workday) && Objects.equals(this.teamMemberIds, other.teamMemberIds);
    }

    public String toString() {
        return "ShiftFilter [locationIds=" + this.locationIds + ", employeeIds=" + this.employeeIds + ", status=" + this.status + ", start=" + this.start + ", end=" + this.end + ", workday=" + this.workday + ", teamMemberIds=" + this.teamMemberIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().status(this.getStatus()).start(this.getStart()).end(this.getEnd()).workday(this.getWorkday());
        builder.locationIds = this.internalGetLocationIds();
        builder.employeeIds = this.internalGetEmployeeIds();
        builder.teamMemberIds = this.internalGetTeamMemberIds();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> locationIds;
        private OptionalNullable<List<String>> employeeIds;
        private String status;
        private TimeRange start;
        private TimeRange end;
        private ShiftWorkday workday;
        private OptionalNullable<List<String>> teamMemberIds;

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = OptionalNullable.of(locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public Builder employeeIds(List<String> employeeIds) {
            this.employeeIds = OptionalNullable.of(employeeIds);
            return this;
        }

        public Builder unsetEmployeeIds() {
            this.employeeIds = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder start(TimeRange start) {
            this.start = start;
            return this;
        }

        public Builder end(TimeRange end) {
            this.end = end;
            return this;
        }

        public Builder workday(ShiftWorkday workday) {
            this.workday = workday;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = OptionalNullable.of(teamMemberIds);
            return this;
        }

        public Builder unsetTeamMemberIds() {
            this.teamMemberIds = null;
            return this;
        }

        public ShiftFilter build() {
            return new ShiftFilter(this.locationIds, this.employeeIds, this.status, this.start, this.end, this.workday, this.teamMemberIds);
        }
    }
}

