/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ShiftWage {
    private final OptionalNullable<String> title;
    private final Money hourlyRate;
    private final String jobId;

    @JsonCreator
    public ShiftWage(@JsonProperty(value="title") String title, @JsonProperty(value="hourly_rate") Money hourlyRate, @JsonProperty(value="job_id") String jobId) {
        this.title = OptionalNullable.of((Object)title);
        this.hourlyRate = hourlyRate;
        this.jobId = jobId;
    }

    protected ShiftWage(OptionalNullable<String> title, Money hourlyRate, String jobId) {
        this.title = title;
        this.hourlyRate = hourlyRate;
        this.jobId = jobId;
    }

    @JsonGetter(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTitle() {
        return this.title;
    }

    @JsonIgnore
    public String getTitle() {
        return (String)OptionalNullable.getFrom(this.title);
    }

    @JsonGetter(value="hourly_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    @JsonGetter(value="job_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getJobId() {
        return this.jobId;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hourlyRate, this.jobId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShiftWage)) {
            return false;
        }
        ShiftWage other = (ShiftWage)obj;
        return Objects.equals(this.title, other.title) && Objects.equals(this.hourlyRate, other.hourlyRate) && Objects.equals(this.jobId, other.jobId);
    }

    public String toString() {
        return "ShiftWage [title=" + this.title + ", hourlyRate=" + this.hourlyRate + ", jobId=" + this.jobId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().hourlyRate(this.getHourlyRate()).jobId(this.getJobId());
        builder.title = this.internalGetTitle();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> title;
        private Money hourlyRate;
        private String jobId;

        public Builder title(String title) {
            this.title = OptionalNullable.of((Object)title);
            return this;
        }

        public Builder unsetTitle() {
            this.title = null;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public ShiftWage build() {
            return new ShiftWage(this.title, this.hourlyRate, this.jobId);
        }
    }
}

