/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.DateRange;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ShiftWorkday {
    private final DateRange dateRange;
    private final String matchShiftsBy;
    private final OptionalNullable<String> defaultTimezone;

    @JsonCreator
    public ShiftWorkday(@JsonProperty(value="date_range") DateRange dateRange, @JsonProperty(value="match_shifts_by") String matchShiftsBy, @JsonProperty(value="default_timezone") String defaultTimezone) {
        this.dateRange = dateRange;
        this.matchShiftsBy = matchShiftsBy;
        this.defaultTimezone = OptionalNullable.of((Object)defaultTimezone);
    }

    protected ShiftWorkday(DateRange dateRange, String matchShiftsBy, OptionalNullable<String> defaultTimezone) {
        this.dateRange = dateRange;
        this.matchShiftsBy = matchShiftsBy;
        this.defaultTimezone = defaultTimezone;
    }

    @JsonGetter(value="date_range")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DateRange getDateRange() {
        return this.dateRange;
    }

    @JsonGetter(value="match_shifts_by")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMatchShiftsBy() {
        return this.matchShiftsBy;
    }

    @JsonGetter(value="default_timezone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDefaultTimezone() {
        return this.defaultTimezone;
    }

    @JsonIgnore
    public String getDefaultTimezone() {
        return (String)OptionalNullable.getFrom(this.defaultTimezone);
    }

    public int hashCode() {
        return Objects.hash(this.dateRange, this.matchShiftsBy, this.defaultTimezone);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShiftWorkday)) {
            return false;
        }
        ShiftWorkday other = (ShiftWorkday)obj;
        return Objects.equals(this.dateRange, other.dateRange) && Objects.equals(this.matchShiftsBy, other.matchShiftsBy) && Objects.equals(this.defaultTimezone, other.defaultTimezone);
    }

    public String toString() {
        return "ShiftWorkday [dateRange=" + this.dateRange + ", matchShiftsBy=" + this.matchShiftsBy + ", defaultTimezone=" + this.defaultTimezone + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().dateRange(this.getDateRange()).matchShiftsBy(this.getMatchShiftsBy());
        builder.defaultTimezone = this.internalGetDefaultTimezone();
        return builder;
    }

    public static class Builder {
        private DateRange dateRange;
        private String matchShiftsBy;
        private OptionalNullable<String> defaultTimezone;

        public Builder dateRange(DateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        public Builder matchShiftsBy(String matchShiftsBy) {
            this.matchShiftsBy = matchShiftsBy;
            return this;
        }

        public Builder defaultTimezone(String defaultTimezone) {
            this.defaultTimezone = OptionalNullable.of((Object)defaultTimezone);
            return this;
        }

        public Builder unsetDefaultTimezone() {
            this.defaultTimezone = null;
            return this;
        }

        public ShiftWorkday build() {
            return new ShiftWorkday(this.dateRange, this.matchShiftsBy, this.defaultTimezone);
        }
    }
}

