/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ShippingFee {
    private final OptionalNullable<String> name;
    private final Money charge;

    @JsonCreator
    public ShippingFee(@JsonProperty(value="charge") Money charge, @JsonProperty(value="name") String name) {
        this.name = OptionalNullable.of((Object)name);
        this.charge = charge;
    }

    protected ShippingFee(Money charge, OptionalNullable<String> name) {
        this.name = name;
        this.charge = charge;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="charge")
    public Money getCharge() {
        return this.charge;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.charge);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShippingFee)) {
            return false;
        }
        ShippingFee other = (ShippingFee)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.charge, other.charge);
    }

    public String toString() {
        return "ShippingFee [charge=" + this.charge + ", name=" + this.name + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.charge);
        builder.name = this.internalGetName();
        return builder;
    }

    public static class Builder {
        private Money charge;
        private OptionalNullable<String> name;

        public Builder(Money charge) {
            this.charge = charge;
        }

        public Builder charge(Money charge) {
            this.charge = charge;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public ShippingFee build() {
            return new ShippingFee(this.charge, this.name);
        }
    }
}

