/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SignatureImage {
    private final String imageType;
    private final String data;

    @JsonCreator
    public SignatureImage(@JsonProperty(value="image_type") String imageType, @JsonProperty(value="data") String data) {
        this.imageType = imageType;
        this.data = data;
    }

    @JsonGetter(value="image_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getImageType() {
        return this.imageType;
    }

    @JsonGetter(value="data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getData() {
        return this.data;
    }

    public int hashCode() {
        return Objects.hash(this.imageType, this.data);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SignatureImage)) {
            return false;
        }
        SignatureImage other = (SignatureImage)obj;
        return Objects.equals(this.imageType, other.imageType) && Objects.equals(this.data, other.data);
    }

    public String toString() {
        return "SignatureImage [imageType=" + this.imageType + ", data=" + this.data + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().imageType(this.getImageType()).data(this.getData());
        return builder;
    }

    public static class Builder {
        private String imageType;
        private String data;

        public Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public SignatureImage build() {
            return new SignatureImage(this.imageType, this.data);
        }
    }
}

