/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SignatureImage;
import java.util.List;
import java.util.Objects;

public class SignatureOptions {
    private final String title;
    private final String body;
    private final List<SignatureImage> signature;

    @JsonCreator
    public SignatureOptions(@JsonProperty(value="title") String title, @JsonProperty(value="body") String body, @JsonProperty(value="signature") List<SignatureImage> signature) {
        this.title = title;
        this.body = body;
        this.signature = signature;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonGetter(value="signature")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<SignatureImage> getSignature() {
        return this.signature;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.signature);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SignatureOptions)) {
            return false;
        }
        SignatureOptions other = (SignatureOptions)obj;
        return Objects.equals(this.title, other.title) && Objects.equals(this.body, other.body) && Objects.equals(this.signature, other.signature);
    }

    public String toString() {
        return "SignatureOptions [title=" + this.title + ", body=" + this.body + ", signature=" + this.signature + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.title, this.body).signature(this.getSignature());
        return builder;
    }

    public static class Builder {
        private String title;
        private String body;
        private List<SignatureImage> signature;

        public Builder(String title, String body) {
            this.title = title;
            this.body = body;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder signature(List<SignatureImage> signature) {
            this.signature = signature;
            return this;
        }

        public SignatureOptions build() {
            return new SignatureOptions(this.title, this.body, this.signature);
        }
    }
}

