/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.MeasurementUnit;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class StandardUnitDescription {
    private final MeasurementUnit unit;
    private final OptionalNullable<String> name;
    private final OptionalNullable<String> abbreviation;

    @JsonCreator
    public StandardUnitDescription(@JsonProperty(value="unit") MeasurementUnit unit, @JsonProperty(value="name") String name, @JsonProperty(value="abbreviation") String abbreviation) {
        this.unit = unit;
        this.name = OptionalNullable.of((Object)name);
        this.abbreviation = OptionalNullable.of((Object)abbreviation);
    }

    protected StandardUnitDescription(MeasurementUnit unit, OptionalNullable<String> name, OptionalNullable<String> abbreviation) {
        this.unit = unit;
        this.name = name;
        this.abbreviation = abbreviation;
    }

    @JsonGetter(value="unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MeasurementUnit getUnit() {
        return this.unit;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="abbreviation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAbbreviation() {
        return this.abbreviation;
    }

    @JsonIgnore
    public String getAbbreviation() {
        return (String)OptionalNullable.getFrom(this.abbreviation);
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.name, this.abbreviation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardUnitDescription)) {
            return false;
        }
        StandardUnitDescription other = (StandardUnitDescription)obj;
        return Objects.equals(this.unit, other.unit) && Objects.equals(this.name, other.name) && Objects.equals(this.abbreviation, other.abbreviation);
    }

    public String toString() {
        return "StandardUnitDescription [unit=" + this.unit + ", name=" + this.name + ", abbreviation=" + this.abbreviation + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().unit(this.getUnit());
        builder.name = this.internalGetName();
        builder.abbreviation = this.internalGetAbbreviation();
        return builder;
    }

    public static class Builder {
        private MeasurementUnit unit;
        private OptionalNullable<String> name;
        private OptionalNullable<String> abbreviation;

        public Builder unit(MeasurementUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = OptionalNullable.of((Object)abbreviation);
            return this;
        }

        public Builder unsetAbbreviation() {
            this.abbreviation = null;
            return this;
        }

        public StandardUnitDescription build() {
            return new StandardUnitDescription(this.unit, this.name, this.abbreviation);
        }
    }
}

