/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Phase;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SubscriptionAction {
    private final String id;
    private final String type;
    private final OptionalNullable<String> effectiveDate;
    private final OptionalNullable<List<Phase>> phases;
    private final OptionalNullable<String> newPlanVariationId;

    @JsonCreator
    public SubscriptionAction(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="effective_date") String effectiveDate, @JsonProperty(value="phases") List<Phase> phases, @JsonProperty(value="new_plan_variation_id") String newPlanVariationId) {
        this.id = id;
        this.type = type;
        this.effectiveDate = OptionalNullable.of((Object)effectiveDate);
        this.phases = OptionalNullable.of(phases);
        this.newPlanVariationId = OptionalNullable.of((Object)newPlanVariationId);
    }

    protected SubscriptionAction(String id, String type, OptionalNullable<String> effectiveDate, OptionalNullable<List<Phase>> phases, OptionalNullable<String> newPlanVariationId) {
        this.id = id;
        this.type = type;
        this.effectiveDate = effectiveDate;
        this.phases = phases;
        this.newPlanVariationId = newPlanVariationId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonIgnore
    public String getEffectiveDate() {
        return (String)OptionalNullable.getFrom(this.effectiveDate);
    }

    @JsonGetter(value="phases")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Phase>> internalGetPhases() {
        return this.phases;
    }

    @JsonIgnore
    public List<Phase> getPhases() {
        return (List)OptionalNullable.getFrom(this.phases);
    }

    @JsonGetter(value="new_plan_variation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNewPlanVariationId() {
        return this.newPlanVariationId;
    }

    @JsonIgnore
    public String getNewPlanVariationId() {
        return (String)OptionalNullable.getFrom(this.newPlanVariationId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.effectiveDate, this.phases, this.newPlanVariationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionAction)) {
            return false;
        }
        SubscriptionAction other = (SubscriptionAction)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type) && Objects.equals(this.effectiveDate, other.effectiveDate) && Objects.equals(this.phases, other.phases) && Objects.equals(this.newPlanVariationId, other.newPlanVariationId);
    }

    public String toString() {
        return "SubscriptionAction [id=" + this.id + ", type=" + this.type + ", effectiveDate=" + this.effectiveDate + ", phases=" + this.phases + ", newPlanVariationId=" + this.newPlanVariationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).type(this.getType());
        builder.effectiveDate = this.internalGetEffectiveDate();
        builder.phases = this.internalGetPhases();
        builder.newPlanVariationId = this.internalGetNewPlanVariationId();
        return builder;
    }

    public static class Builder {
        private String id;
        private String type;
        private OptionalNullable<String> effectiveDate;
        private OptionalNullable<List<Phase>> phases;
        private OptionalNullable<String> newPlanVariationId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = OptionalNullable.of((Object)effectiveDate);
            return this;
        }

        public Builder unsetEffectiveDate() {
            this.effectiveDate = null;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = OptionalNullable.of(phases);
            return this;
        }

        public Builder unsetPhases() {
            this.phases = null;
            return this;
        }

        public Builder newPlanVariationId(String newPlanVariationId) {
            this.newPlanVariationId = OptionalNullable.of((Object)newPlanVariationId);
            return this;
        }

        public Builder unsetNewPlanVariationId() {
            this.newPlanVariationId = null;
            return this;
        }

        public SubscriptionAction build() {
            return new SubscriptionAction(this.id, this.type, this.effectiveDate, this.phases, this.newPlanVariationId);
        }
    }
}

