/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import com.squareup.square.models.SubscriptionPricing;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class SubscriptionPhase {
    private final OptionalNullable<String> uid;
    private final String cadence;
    private final OptionalNullable<Integer> periods;
    private final Money recurringPriceMoney;
    private final OptionalNullable<Long> ordinal;
    private final SubscriptionPricing pricing;

    @JsonCreator
    public SubscriptionPhase(@JsonProperty(value="cadence") String cadence, @JsonProperty(value="uid") String uid, @JsonProperty(value="periods") Integer periods, @JsonProperty(value="recurring_price_money") Money recurringPriceMoney, @JsonProperty(value="ordinal") Long ordinal, @JsonProperty(value="pricing") SubscriptionPricing pricing) {
        this.uid = OptionalNullable.of((Object)uid);
        this.cadence = cadence;
        this.periods = OptionalNullable.of((Object)periods);
        this.recurringPriceMoney = recurringPriceMoney;
        this.ordinal = OptionalNullable.of((Object)ordinal);
        this.pricing = pricing;
    }

    protected SubscriptionPhase(String cadence, OptionalNullable<String> uid, OptionalNullable<Integer> periods, Money recurringPriceMoney, OptionalNullable<Long> ordinal, SubscriptionPricing pricing) {
        this.uid = uid;
        this.cadence = cadence;
        this.periods = periods;
        this.recurringPriceMoney = recurringPriceMoney;
        this.ordinal = ordinal;
        this.pricing = pricing;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="cadence")
    public String getCadence() {
        return this.cadence;
    }

    @JsonGetter(value="periods")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetPeriods() {
        return this.periods;
    }

    @JsonIgnore
    public Integer getPeriods() {
        return (Integer)OptionalNullable.getFrom(this.periods);
    }

    @JsonGetter(value="recurring_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getRecurringPriceMoney() {
        return this.recurringPriceMoney;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetOrdinal() {
        return this.ordinal;
    }

    @JsonIgnore
    public Long getOrdinal() {
        return (Long)OptionalNullable.getFrom(this.ordinal);
    }

    @JsonGetter(value="pricing")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SubscriptionPricing getPricing() {
        return this.pricing;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.cadence, this.periods, this.recurringPriceMoney, this.ordinal, this.pricing);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionPhase)) {
            return false;
        }
        SubscriptionPhase other = (SubscriptionPhase)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.cadence, other.cadence) && Objects.equals(this.periods, other.periods) && Objects.equals(this.recurringPriceMoney, other.recurringPriceMoney) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.pricing, other.pricing);
    }

    public String toString() {
        return "SubscriptionPhase [cadence=" + this.cadence + ", uid=" + this.uid + ", periods=" + this.periods + ", recurringPriceMoney=" + this.recurringPriceMoney + ", ordinal=" + this.ordinal + ", pricing=" + this.pricing + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.cadence).recurringPriceMoney(this.getRecurringPriceMoney()).pricing(this.getPricing());
        builder.uid = this.internalGetUid();
        builder.periods = this.internalGetPeriods();
        builder.ordinal = this.internalGetOrdinal();
        return builder;
    }

    public static class Builder {
        private String cadence;
        private OptionalNullable<String> uid;
        private OptionalNullable<Integer> periods;
        private Money recurringPriceMoney;
        private OptionalNullable<Long> ordinal;
        private SubscriptionPricing pricing;

        public Builder(String cadence) {
            this.cadence = cadence;
        }

        public Builder cadence(String cadence) {
            this.cadence = cadence;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder periods(Integer periods) {
            this.periods = OptionalNullable.of((Object)periods);
            return this;
        }

        public Builder unsetPeriods() {
            this.periods = null;
            return this;
        }

        public Builder recurringPriceMoney(Money recurringPriceMoney) {
            this.recurringPriceMoney = recurringPriceMoney;
            return this;
        }

        public Builder ordinal(Long ordinal) {
            this.ordinal = OptionalNullable.of((Object)ordinal);
            return this;
        }

        public Builder unsetOrdinal() {
            this.ordinal = null;
            return this;
        }

        public Builder pricing(SubscriptionPricing pricing) {
            this.pricing = pricing;
            return this;
        }

        public SubscriptionPhase build() {
            return new SubscriptionPhase(this.cadence, this.uid, this.periods, this.recurringPriceMoney, this.ordinal, this.pricing);
        }
    }
}

