/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SubscriptionPricing {
    private final String type;
    private final OptionalNullable<List<String>> discountIds;
    private final Money priceMoney;

    @JsonCreator
    public SubscriptionPricing(@JsonProperty(value="type") String type, @JsonProperty(value="discount_ids") List<String> discountIds, @JsonProperty(value="price_money") Money priceMoney) {
        this.type = type;
        this.discountIds = OptionalNullable.of(discountIds);
        this.priceMoney = priceMoney;
    }

    protected SubscriptionPricing(String type, OptionalNullable<List<String>> discountIds, Money priceMoney) {
        this.type = type;
        this.discountIds = discountIds;
        this.priceMoney = priceMoney;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="discount_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetDiscountIds() {
        return this.discountIds;
    }

    @JsonIgnore
    public List<String> getDiscountIds() {
        return (List)OptionalNullable.getFrom(this.discountIds);
    }

    @JsonGetter(value="price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.discountIds, this.priceMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionPricing)) {
            return false;
        }
        SubscriptionPricing other = (SubscriptionPricing)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.discountIds, other.discountIds) && Objects.equals(this.priceMoney, other.priceMoney);
    }

    public String toString() {
        return "SubscriptionPricing [type=" + this.type + ", discountIds=" + this.discountIds + ", priceMoney=" + this.priceMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().type(this.getType()).priceMoney(this.getPriceMoney());
        builder.discountIds = this.internalGetDiscountIds();
        return builder;
    }

    public static class Builder {
        private String type;
        private OptionalNullable<List<String>> discountIds;
        private Money priceMoney;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder discountIds(List<String> discountIds) {
            this.discountIds = OptionalNullable.of(discountIds);
            return this;
        }

        public Builder unsetDiscountIds() {
            this.discountIds = null;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public SubscriptionPricing build() {
            return new SubscriptionPricing(this.type, this.discountIds, this.priceMoney);
        }
    }
}

