/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.PhaseInput;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SwapPlanRequest {
    private final OptionalNullable<String> newPlanVariationId;
    private final OptionalNullable<List<PhaseInput>> phases;

    @JsonCreator
    public SwapPlanRequest(@JsonProperty(value="new_plan_variation_id") String newPlanVariationId, @JsonProperty(value="phases") List<PhaseInput> phases) {
        this.newPlanVariationId = OptionalNullable.of((Object)newPlanVariationId);
        this.phases = OptionalNullable.of(phases);
    }

    protected SwapPlanRequest(OptionalNullable<String> newPlanVariationId, OptionalNullable<List<PhaseInput>> phases) {
        this.newPlanVariationId = newPlanVariationId;
        this.phases = phases;
    }

    @JsonGetter(value="new_plan_variation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNewPlanVariationId() {
        return this.newPlanVariationId;
    }

    @JsonIgnore
    public String getNewPlanVariationId() {
        return (String)OptionalNullable.getFrom(this.newPlanVariationId);
    }

    @JsonGetter(value="phases")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<PhaseInput>> internalGetPhases() {
        return this.phases;
    }

    @JsonIgnore
    public List<PhaseInput> getPhases() {
        return (List)OptionalNullable.getFrom(this.phases);
    }

    public int hashCode() {
        return Objects.hash(this.newPlanVariationId, this.phases);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SwapPlanRequest)) {
            return false;
        }
        SwapPlanRequest other = (SwapPlanRequest)obj;
        return Objects.equals(this.newPlanVariationId, other.newPlanVariationId) && Objects.equals(this.phases, other.phases);
    }

    public String toString() {
        return "SwapPlanRequest [newPlanVariationId=" + this.newPlanVariationId + ", phases=" + this.phases + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.newPlanVariationId = this.internalGetNewPlanVariationId();
        builder.phases = this.internalGetPhases();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> newPlanVariationId;
        private OptionalNullable<List<PhaseInput>> phases;

        public Builder newPlanVariationId(String newPlanVariationId) {
            this.newPlanVariationId = OptionalNullable.of((Object)newPlanVariationId);
            return this;
        }

        public Builder unsetNewPlanVariationId() {
            this.newPlanVariationId = null;
            return this;
        }

        public Builder phases(List<PhaseInput> phases) {
            this.phases = OptionalNullable.of(phases);
            return this;
        }

        public Builder unsetPhases() {
            this.phases = null;
            return this;
        }

        public SwapPlanRequest build() {
            return new SwapPlanRequest(this.newPlanVariationId, this.phases);
        }
    }
}

