/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class TaxIds {
    private final OptionalNullable<String> euVat;
    private final OptionalNullable<String> frSiret;
    private final OptionalNullable<String> frNaf;
    private final OptionalNullable<String> esNif;

    @JsonCreator
    public TaxIds(@JsonProperty(value="eu_vat") String euVat, @JsonProperty(value="fr_siret") String frSiret, @JsonProperty(value="fr_naf") String frNaf, @JsonProperty(value="es_nif") String esNif) {
        this.euVat = OptionalNullable.of((Object)euVat);
        this.frSiret = OptionalNullable.of((Object)frSiret);
        this.frNaf = OptionalNullable.of((Object)frNaf);
        this.esNif = OptionalNullable.of((Object)esNif);
    }

    protected TaxIds(OptionalNullable<String> euVat, OptionalNullable<String> frSiret, OptionalNullable<String> frNaf, OptionalNullable<String> esNif) {
        this.euVat = euVat;
        this.frSiret = frSiret;
        this.frNaf = frNaf;
        this.esNif = esNif;
    }

    @JsonGetter(value="eu_vat")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEuVat() {
        return this.euVat;
    }

    @JsonIgnore
    public String getEuVat() {
        return (String)OptionalNullable.getFrom(this.euVat);
    }

    @JsonGetter(value="fr_siret")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFrSiret() {
        return this.frSiret;
    }

    @JsonIgnore
    public String getFrSiret() {
        return (String)OptionalNullable.getFrom(this.frSiret);
    }

    @JsonGetter(value="fr_naf")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFrNaf() {
        return this.frNaf;
    }

    @JsonIgnore
    public String getFrNaf() {
        return (String)OptionalNullable.getFrom(this.frNaf);
    }

    @JsonGetter(value="es_nif")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEsNif() {
        return this.esNif;
    }

    @JsonIgnore
    public String getEsNif() {
        return (String)OptionalNullable.getFrom(this.esNif);
    }

    public int hashCode() {
        return Objects.hash(this.euVat, this.frSiret, this.frNaf, this.esNif);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaxIds)) {
            return false;
        }
        TaxIds other = (TaxIds)obj;
        return Objects.equals(this.euVat, other.euVat) && Objects.equals(this.frSiret, other.frSiret) && Objects.equals(this.frNaf, other.frNaf) && Objects.equals(this.esNif, other.esNif);
    }

    public String toString() {
        return "TaxIds [euVat=" + this.euVat + ", frSiret=" + this.frSiret + ", frNaf=" + this.frNaf + ", esNif=" + this.esNif + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.euVat = this.internalGetEuVat();
        builder.frSiret = this.internalGetFrSiret();
        builder.frNaf = this.internalGetFrNaf();
        builder.esNif = this.internalGetEsNif();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> euVat;
        private OptionalNullable<String> frSiret;
        private OptionalNullable<String> frNaf;
        private OptionalNullable<String> esNif;

        public Builder euVat(String euVat) {
            this.euVat = OptionalNullable.of((Object)euVat);
            return this;
        }

        public Builder unsetEuVat() {
            this.euVat = null;
            return this;
        }

        public Builder frSiret(String frSiret) {
            this.frSiret = OptionalNullable.of((Object)frSiret);
            return this;
        }

        public Builder unsetFrSiret() {
            this.frSiret = null;
            return this;
        }

        public Builder frNaf(String frNaf) {
            this.frNaf = OptionalNullable.of((Object)frNaf);
            return this;
        }

        public Builder unsetFrNaf() {
            this.frNaf = null;
            return this;
        }

        public Builder esNif(String esNif) {
            this.esNif = OptionalNullable.of((Object)esNif);
            return this;
        }

        public Builder unsetEsNif() {
            this.esNif = null;
            return this;
        }

        public TaxIds build() {
            return new TaxIds(this.euVat, this.frSiret, this.frNaf, this.esNif);
        }
    }
}

