/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class TeamMemberWage {
    private final String id;
    private final OptionalNullable<String> teamMemberId;
    private final OptionalNullable<String> title;
    private final Money hourlyRate;
    private final OptionalNullable<String> jobId;

    @JsonCreator
    public TeamMemberWage(@JsonProperty(value="id") String id, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="title") String title, @JsonProperty(value="hourly_rate") Money hourlyRate, @JsonProperty(value="job_id") String jobId) {
        this.id = id;
        this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
        this.title = OptionalNullable.of((Object)title);
        this.hourlyRate = hourlyRate;
        this.jobId = OptionalNullable.of((Object)jobId);
    }

    protected TeamMemberWage(String id, OptionalNullable<String> teamMemberId, OptionalNullable<String> title, Money hourlyRate, OptionalNullable<String> jobId) {
        this.id = id;
        this.teamMemberId = teamMemberId;
        this.title = title;
        this.hourlyRate = hourlyRate;
        this.jobId = jobId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonIgnore
    public String getTeamMemberId() {
        return (String)OptionalNullable.getFrom(this.teamMemberId);
    }

    @JsonGetter(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTitle() {
        return this.title;
    }

    @JsonIgnore
    public String getTitle() {
        return (String)OptionalNullable.getFrom(this.title);
    }

    @JsonGetter(value="hourly_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    @JsonGetter(value="job_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetJobId() {
        return this.jobId;
    }

    @JsonIgnore
    public String getJobId() {
        return (String)OptionalNullable.getFrom(this.jobId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.teamMemberId, this.title, this.hourlyRate, this.jobId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TeamMemberWage)) {
            return false;
        }
        TeamMemberWage other = (TeamMemberWage)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.title, other.title) && Objects.equals(this.hourlyRate, other.hourlyRate) && Objects.equals(this.jobId, other.jobId);
    }

    public String toString() {
        return "TeamMemberWage [id=" + this.id + ", teamMemberId=" + this.teamMemberId + ", title=" + this.title + ", hourlyRate=" + this.hourlyRate + ", jobId=" + this.jobId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).hourlyRate(this.getHourlyRate());
        builder.teamMemberId = this.internalGetTeamMemberId();
        builder.title = this.internalGetTitle();
        builder.jobId = this.internalGetJobId();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> teamMemberId;
        private OptionalNullable<String> title;
        private Money hourlyRate;
        private OptionalNullable<String> jobId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
            return this;
        }

        public Builder unsetTeamMemberId() {
            this.teamMemberId = null;
            return this;
        }

        public Builder title(String title) {
            this.title = OptionalNullable.of((Object)title);
            return this;
        }

        public Builder unsetTitle() {
            this.title = null;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = OptionalNullable.of((Object)jobId);
            return this;
        }

        public Builder unsetJobId() {
            this.jobId = null;
            return this;
        }

        public TeamMemberWage build() {
            return new TeamMemberWage(this.id, this.teamMemberId, this.title, this.hourlyRate, this.jobId);
        }
    }
}

