/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.AdditionalRecipient;
import com.squareup.square.models.Money;
import com.squareup.square.models.TenderCardDetails;
import com.squareup.square.models.TenderCashDetails;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Tender {
    private final String id;
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<String> transactionId;
    private final String createdAt;
    private final OptionalNullable<String> note;
    private final Money amountMoney;
    private final Money tipMoney;
    private final Money processingFeeMoney;
    private final OptionalNullable<String> customerId;
    private final String type;
    private final TenderCardDetails cardDetails;
    private final TenderCashDetails cashDetails;
    private final OptionalNullable<List<AdditionalRecipient>> additionalRecipients;
    private final OptionalNullable<String> paymentId;

    @JsonCreator
    public Tender(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="transaction_id") String transactionId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="note") String note, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="tip_money") Money tipMoney, @JsonProperty(value="processing_fee_money") Money processingFeeMoney, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="card_details") TenderCardDetails cardDetails, @JsonProperty(value="cash_details") TenderCashDetails cashDetails, @JsonProperty(value="additional_recipients") List<AdditionalRecipient> additionalRecipients, @JsonProperty(value="payment_id") String paymentId) {
        this.id = id;
        this.locationId = OptionalNullable.of((Object)locationId);
        this.transactionId = OptionalNullable.of((Object)transactionId);
        this.createdAt = createdAt;
        this.note = OptionalNullable.of((Object)note);
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.processingFeeMoney = processingFeeMoney;
        this.customerId = OptionalNullable.of((Object)customerId);
        this.type = type;
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.additionalRecipients = OptionalNullable.of(additionalRecipients);
        this.paymentId = OptionalNullable.of((Object)paymentId);
    }

    protected Tender(String type, String id, OptionalNullable<String> locationId, OptionalNullable<String> transactionId, String createdAt, OptionalNullable<String> note, Money amountMoney, Money tipMoney, Money processingFeeMoney, OptionalNullable<String> customerId, TenderCardDetails cardDetails, TenderCashDetails cashDetails, OptionalNullable<List<AdditionalRecipient>> additionalRecipients, OptionalNullable<String> paymentId) {
        this.id = id;
        this.locationId = locationId;
        this.transactionId = transactionId;
        this.createdAt = createdAt;
        this.note = note;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.processingFeeMoney = processingFeeMoney;
        this.customerId = customerId;
        this.type = type;
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.additionalRecipients = additionalRecipients;
        this.paymentId = paymentId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="transaction_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTransactionId() {
        return this.transactionId;
    }

    @JsonIgnore
    public String getTransactionId() {
        return (String)OptionalNullable.getFrom(this.transactionId);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTipMoney() {
        return this.tipMoney;
    }

    @JsonGetter(value="processing_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="card_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TenderCardDetails getCardDetails() {
        return this.cardDetails;
    }

    @JsonGetter(value="cash_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TenderCashDetails getCashDetails() {
        return this.cashDetails;
    }

    @JsonGetter(value="additional_recipients")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<AdditionalRecipient>> internalGetAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonIgnore
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return (List)OptionalNullable.getFrom(this.additionalRecipients);
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public String getPaymentId() {
        return (String)OptionalNullable.getFrom(this.paymentId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.transactionId, this.createdAt, this.note, this.amountMoney, this.tipMoney, this.processingFeeMoney, this.customerId, this.type, this.cardDetails, this.cashDetails, this.additionalRecipients, this.paymentId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Tender)) {
            return false;
        }
        Tender other = (Tender)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.transactionId, other.transactionId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.note, other.note) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.tipMoney, other.tipMoney) && Objects.equals(this.processingFeeMoney, other.processingFeeMoney) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.type, other.type) && Objects.equals(this.cardDetails, other.cardDetails) && Objects.equals(this.cashDetails, other.cashDetails) && Objects.equals(this.additionalRecipients, other.additionalRecipients) && Objects.equals(this.paymentId, other.paymentId);
    }

    public String toString() {
        return "Tender [type=" + this.type + ", id=" + this.id + ", locationId=" + this.locationId + ", transactionId=" + this.transactionId + ", createdAt=" + this.createdAt + ", note=" + this.note + ", amountMoney=" + this.amountMoney + ", tipMoney=" + this.tipMoney + ", processingFeeMoney=" + this.processingFeeMoney + ", customerId=" + this.customerId + ", cardDetails=" + this.cardDetails + ", cashDetails=" + this.cashDetails + ", additionalRecipients=" + this.additionalRecipients + ", paymentId=" + this.paymentId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type).id(this.getId()).createdAt(this.getCreatedAt()).amountMoney(this.getAmountMoney()).tipMoney(this.getTipMoney()).processingFeeMoney(this.getProcessingFeeMoney()).cardDetails(this.getCardDetails()).cashDetails(this.getCashDetails());
        builder.locationId = this.internalGetLocationId();
        builder.transactionId = this.internalGetTransactionId();
        builder.note = this.internalGetNote();
        builder.customerId = this.internalGetCustomerId();
        builder.additionalRecipients = this.internalGetAdditionalRecipients();
        builder.paymentId = this.internalGetPaymentId();
        return builder;
    }

    public static class Builder {
        private String type;
        private String id;
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> transactionId;
        private String createdAt;
        private OptionalNullable<String> note;
        private Money amountMoney;
        private Money tipMoney;
        private Money processingFeeMoney;
        private OptionalNullable<String> customerId;
        private TenderCardDetails cardDetails;
        private TenderCashDetails cashDetails;
        private OptionalNullable<List<AdditionalRecipient>> additionalRecipients;
        private OptionalNullable<String> paymentId;

        public Builder(String type) {
            this.type = type;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = OptionalNullable.of((Object)transactionId);
            return this;
        }

        public Builder unsetTransactionId() {
            this.transactionId = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder tipMoney(Money tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder processingFeeMoney(Money processingFeeMoney) {
            this.processingFeeMoney = processingFeeMoney;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder cardDetails(TenderCardDetails cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }

        public Builder cashDetails(TenderCashDetails cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        public Builder additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = OptionalNullable.of(additionalRecipients);
            return this;
        }

        public Builder unsetAdditionalRecipients() {
            this.additionalRecipients = null;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = OptionalNullable.of((Object)paymentId);
            return this;
        }

        public Builder unsetPaymentId() {
            this.paymentId = null;
            return this;
        }

        public Tender build() {
            return new Tender(this.type, this.id, this.locationId, this.transactionId, this.createdAt, this.note, this.amountMoney, this.tipMoney, this.processingFeeMoney, this.customerId, this.cardDetails, this.cashDetails, this.additionalRecipients, this.paymentId);
        }
    }
}

