/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class TenderCashDetails {
    private final Money buyerTenderedMoney;
    private final Money changeBackMoney;

    @JsonCreator
    public TenderCashDetails(@JsonProperty(value="buyer_tendered_money") Money buyerTenderedMoney, @JsonProperty(value="change_back_money") Money changeBackMoney) {
        this.buyerTenderedMoney = buyerTenderedMoney;
        this.changeBackMoney = changeBackMoney;
    }

    @JsonGetter(value="buyer_tendered_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBuyerTenderedMoney() {
        return this.buyerTenderedMoney;
    }

    @JsonGetter(value="change_back_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getChangeBackMoney() {
        return this.changeBackMoney;
    }

    public int hashCode() {
        return Objects.hash(this.buyerTenderedMoney, this.changeBackMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TenderCashDetails)) {
            return false;
        }
        TenderCashDetails other = (TenderCashDetails)obj;
        return Objects.equals(this.buyerTenderedMoney, other.buyerTenderedMoney) && Objects.equals(this.changeBackMoney, other.changeBackMoney);
    }

    public String toString() {
        return "TenderCashDetails [buyerTenderedMoney=" + this.buyerTenderedMoney + ", changeBackMoney=" + this.changeBackMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().buyerTenderedMoney(this.getBuyerTenderedMoney()).changeBackMoney(this.getChangeBackMoney());
        return builder;
    }

    public static class Builder {
        private Money buyerTenderedMoney;
        private Money changeBackMoney;

        public Builder buyerTenderedMoney(Money buyerTenderedMoney) {
            this.buyerTenderedMoney = buyerTenderedMoney;
            return this;
        }

        public Builder changeBackMoney(Money changeBackMoney) {
            this.changeBackMoney = changeBackMoney;
            return this;
        }

        public TenderCashDetails build() {
            return new TenderCashDetails(this.buyerTenderedMoney, this.changeBackMoney);
        }
    }
}

