/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.SubscriptionTestResult;
import java.util.List;
import java.util.Objects;

public class TestWebhookSubscriptionResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final SubscriptionTestResult subscriptionTestResult;

    @JsonCreator
    public TestWebhookSubscriptionResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="subscription_test_result") SubscriptionTestResult subscriptionTestResult) {
        this.errors = errors;
        this.subscriptionTestResult = subscriptionTestResult;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="subscription_test_result")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SubscriptionTestResult getSubscriptionTestResult() {
        return this.subscriptionTestResult;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscriptionTestResult);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TestWebhookSubscriptionResponse)) {
            return false;
        }
        TestWebhookSubscriptionResponse other = (TestWebhookSubscriptionResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.subscriptionTestResult, other.subscriptionTestResult);
    }

    public String toString() {
        return "TestWebhookSubscriptionResponse [errors=" + this.errors + ", subscriptionTestResult=" + this.subscriptionTestResult + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).subscriptionTestResult(this.getSubscriptionTestResult());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private SubscriptionTestResult subscriptionTestResult;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder subscriptionTestResult(SubscriptionTestResult subscriptionTestResult) {
            this.subscriptionTestResult = subscriptionTestResult;
            return this;
        }

        public TestWebhookSubscriptionResponse build() {
            TestWebhookSubscriptionResponse model = new TestWebhookSubscriptionResponse(this.errors, this.subscriptionTestResult);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

