/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class TipSettings {
    private final OptionalNullable<Boolean> allowTipping;
    private final OptionalNullable<Boolean> separateTipScreen;
    private final OptionalNullable<Boolean> customTipField;
    private final OptionalNullable<List<Integer>> tipPercentages;
    private final OptionalNullable<Boolean> smartTipping;

    @JsonCreator
    public TipSettings(@JsonProperty(value="allow_tipping") Boolean allowTipping, @JsonProperty(value="separate_tip_screen") Boolean separateTipScreen, @JsonProperty(value="custom_tip_field") Boolean customTipField, @JsonProperty(value="tip_percentages") List<Integer> tipPercentages, @JsonProperty(value="smart_tipping") Boolean smartTipping) {
        this.allowTipping = OptionalNullable.of((Object)allowTipping);
        this.separateTipScreen = OptionalNullable.of((Object)separateTipScreen);
        this.customTipField = OptionalNullable.of((Object)customTipField);
        this.tipPercentages = OptionalNullable.of(tipPercentages);
        this.smartTipping = OptionalNullable.of((Object)smartTipping);
    }

    protected TipSettings(OptionalNullable<Boolean> allowTipping, OptionalNullable<Boolean> separateTipScreen, OptionalNullable<Boolean> customTipField, OptionalNullable<List<Integer>> tipPercentages, OptionalNullable<Boolean> smartTipping) {
        this.allowTipping = allowTipping;
        this.separateTipScreen = separateTipScreen;
        this.customTipField = customTipField;
        this.tipPercentages = tipPercentages;
        this.smartTipping = smartTipping;
    }

    @JsonGetter(value="allow_tipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAllowTipping() {
        return this.allowTipping;
    }

    @JsonIgnore
    public Boolean getAllowTipping() {
        return (Boolean)OptionalNullable.getFrom(this.allowTipping);
    }

    @JsonGetter(value="separate_tip_screen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetSeparateTipScreen() {
        return this.separateTipScreen;
    }

    @JsonIgnore
    public Boolean getSeparateTipScreen() {
        return (Boolean)OptionalNullable.getFrom(this.separateTipScreen);
    }

    @JsonGetter(value="custom_tip_field")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetCustomTipField() {
        return this.customTipField;
    }

    @JsonIgnore
    public Boolean getCustomTipField() {
        return (Boolean)OptionalNullable.getFrom(this.customTipField);
    }

    @JsonGetter(value="tip_percentages")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Integer>> internalGetTipPercentages() {
        return this.tipPercentages;
    }

    @JsonIgnore
    public List<Integer> getTipPercentages() {
        return (List)OptionalNullable.getFrom(this.tipPercentages);
    }

    @JsonGetter(value="smart_tipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetSmartTipping() {
        return this.smartTipping;
    }

    @JsonIgnore
    public Boolean getSmartTipping() {
        return (Boolean)OptionalNullable.getFrom(this.smartTipping);
    }

    public int hashCode() {
        return Objects.hash(this.allowTipping, this.separateTipScreen, this.customTipField, this.tipPercentages, this.smartTipping);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TipSettings)) {
            return false;
        }
        TipSettings other = (TipSettings)obj;
        return Objects.equals(this.allowTipping, other.allowTipping) && Objects.equals(this.separateTipScreen, other.separateTipScreen) && Objects.equals(this.customTipField, other.customTipField) && Objects.equals(this.tipPercentages, other.tipPercentages) && Objects.equals(this.smartTipping, other.smartTipping);
    }

    public String toString() {
        return "TipSettings [allowTipping=" + this.allowTipping + ", separateTipScreen=" + this.separateTipScreen + ", customTipField=" + this.customTipField + ", tipPercentages=" + this.tipPercentages + ", smartTipping=" + this.smartTipping + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.allowTipping = this.internalGetAllowTipping();
        builder.separateTipScreen = this.internalGetSeparateTipScreen();
        builder.customTipField = this.internalGetCustomTipField();
        builder.tipPercentages = this.internalGetTipPercentages();
        builder.smartTipping = this.internalGetSmartTipping();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Boolean> allowTipping;
        private OptionalNullable<Boolean> separateTipScreen;
        private OptionalNullable<Boolean> customTipField;
        private OptionalNullable<List<Integer>> tipPercentages;
        private OptionalNullable<Boolean> smartTipping;

        public Builder allowTipping(Boolean allowTipping) {
            this.allowTipping = OptionalNullable.of((Object)allowTipping);
            return this;
        }

        public Builder unsetAllowTipping() {
            this.allowTipping = null;
            return this;
        }

        public Builder separateTipScreen(Boolean separateTipScreen) {
            this.separateTipScreen = OptionalNullable.of((Object)separateTipScreen);
            return this;
        }

        public Builder unsetSeparateTipScreen() {
            this.separateTipScreen = null;
            return this;
        }

        public Builder customTipField(Boolean customTipField) {
            this.customTipField = OptionalNullable.of((Object)customTipField);
            return this;
        }

        public Builder unsetCustomTipField() {
            this.customTipField = null;
            return this;
        }

        public Builder tipPercentages(List<Integer> tipPercentages) {
            this.tipPercentages = OptionalNullable.of(tipPercentages);
            return this;
        }

        public Builder unsetTipPercentages() {
            this.tipPercentages = null;
            return this;
        }

        public Builder smartTipping(Boolean smartTipping) {
            this.smartTipping = OptionalNullable.of((Object)smartTipping);
            return this;
        }

        public Builder unsetSmartTipping() {
            this.smartTipping = null;
            return this;
        }

        public TipSettings build() {
            return new TipSettings(this.allowTipping, this.separateTipScreen, this.customTipField, this.tipPercentages, this.smartTipping);
        }
    }
}

