/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomAttributeDefinition;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class UpdateBookingCustomAttributeDefinitionRequest {
    private final CustomAttributeDefinition customAttributeDefinition;
    private final OptionalNullable<String> idempotencyKey;

    @JsonCreator
    public UpdateBookingCustomAttributeDefinitionRequest(@JsonProperty(value="custom_attribute_definition") CustomAttributeDefinition customAttributeDefinition, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.customAttributeDefinition = customAttributeDefinition;
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
    }

    protected UpdateBookingCustomAttributeDefinitionRequest(CustomAttributeDefinition customAttributeDefinition, OptionalNullable<String> idempotencyKey) {
        this.customAttributeDefinition = customAttributeDefinition;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="custom_attribute_definition")
    public CustomAttributeDefinition getCustomAttributeDefinition() {
        return this.customAttributeDefinition;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.customAttributeDefinition, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateBookingCustomAttributeDefinitionRequest)) {
            return false;
        }
        UpdateBookingCustomAttributeDefinitionRequest other = (UpdateBookingCustomAttributeDefinitionRequest)obj;
        return Objects.equals(this.customAttributeDefinition, other.customAttributeDefinition) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "UpdateBookingCustomAttributeDefinitionRequest [customAttributeDefinition=" + this.customAttributeDefinition + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.customAttributeDefinition);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private CustomAttributeDefinition customAttributeDefinition;
        private OptionalNullable<String> idempotencyKey;

        public Builder(CustomAttributeDefinition customAttributeDefinition) {
            this.customAttributeDefinition = customAttributeDefinition;
        }

        public Builder customAttributeDefinition(CustomAttributeDefinition customAttributeDefinition) {
            this.customAttributeDefinition = customAttributeDefinition;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public UpdateBookingCustomAttributeDefinitionRequest build() {
            return new UpdateBookingCustomAttributeDefinitionRequest(this.customAttributeDefinition, this.idempotencyKey);
        }
    }
}

