/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Booking;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class UpdateBookingRequest {
    private final OptionalNullable<String> idempotencyKey;
    private final Booking booking;

    @JsonCreator
    public UpdateBookingRequest(@JsonProperty(value="booking") Booking booking, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
        this.booking = booking;
    }

    protected UpdateBookingRequest(Booking booking, OptionalNullable<String> idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        this.booking = booking;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    @JsonGetter(value="booking")
    public Booking getBooking() {
        return this.booking;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.booking);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateBookingRequest)) {
            return false;
        }
        UpdateBookingRequest other = (UpdateBookingRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.booking, other.booking);
    }

    public String toString() {
        return "UpdateBookingRequest [booking=" + this.booking + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.booking);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private Booking booking;
        private OptionalNullable<String> idempotencyKey;

        public Builder(Booking booking) {
            this.booking = booking;
        }

        public Builder booking(Booking booking) {
            this.booking = booking;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public UpdateBookingRequest build() {
            return new UpdateBookingRequest(this.booking, this.idempotencyKey);
        }
    }
}

