/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Invoice;
import java.util.List;
import java.util.Objects;

public class UpdateInvoiceResponse {
    private HttpContext httpContext;
    private final Invoice invoice;
    private final List<Error> errors;

    @JsonCreator
    public UpdateInvoiceResponse(@JsonProperty(value="invoice") Invoice invoice, @JsonProperty(value="errors") List<Error> errors) {
        this.invoice = invoice;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="invoice")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Invoice getInvoice() {
        return this.invoice;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.invoice, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateInvoiceResponse)) {
            return false;
        }
        UpdateInvoiceResponse other = (UpdateInvoiceResponse)obj;
        return Objects.equals(this.invoice, other.invoice) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "UpdateInvoiceResponse [invoice=" + this.invoice + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().invoice(this.getInvoice()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Invoice invoice;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder invoice(Invoice invoice) {
            this.invoice = invoice;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public UpdateInvoiceResponse build() {
            UpdateInvoiceResponse model = new UpdateInvoiceResponse(this.invoice, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

