/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class UpdateItemTaxesRequest {
    private final List<String> itemIds;
    private final OptionalNullable<List<String>> taxesToEnable;
    private final OptionalNullable<List<String>> taxesToDisable;

    @JsonCreator
    public UpdateItemTaxesRequest(@JsonProperty(value="item_ids") List<String> itemIds, @JsonProperty(value="taxes_to_enable") List<String> taxesToEnable, @JsonProperty(value="taxes_to_disable") List<String> taxesToDisable) {
        this.itemIds = itemIds;
        this.taxesToEnable = OptionalNullable.of(taxesToEnable);
        this.taxesToDisable = OptionalNullable.of(taxesToDisable);
    }

    protected UpdateItemTaxesRequest(List<String> itemIds, OptionalNullable<List<String>> taxesToEnable, OptionalNullable<List<String>> taxesToDisable) {
        this.itemIds = itemIds;
        this.taxesToEnable = taxesToEnable;
        this.taxesToDisable = taxesToDisable;
    }

    @JsonGetter(value="item_ids")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    @JsonGetter(value="taxes_to_enable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetTaxesToEnable() {
        return this.taxesToEnable;
    }

    @JsonIgnore
    public List<String> getTaxesToEnable() {
        return (List)OptionalNullable.getFrom(this.taxesToEnable);
    }

    @JsonGetter(value="taxes_to_disable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetTaxesToDisable() {
        return this.taxesToDisable;
    }

    @JsonIgnore
    public List<String> getTaxesToDisable() {
        return (List)OptionalNullable.getFrom(this.taxesToDisable);
    }

    public int hashCode() {
        return Objects.hash(this.itemIds, this.taxesToEnable, this.taxesToDisable);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateItemTaxesRequest)) {
            return false;
        }
        UpdateItemTaxesRequest other = (UpdateItemTaxesRequest)obj;
        return Objects.equals(this.itemIds, other.itemIds) && Objects.equals(this.taxesToEnable, other.taxesToEnable) && Objects.equals(this.taxesToDisable, other.taxesToDisable);
    }

    public String toString() {
        return "UpdateItemTaxesRequest [itemIds=" + this.itemIds + ", taxesToEnable=" + this.taxesToEnable + ", taxesToDisable=" + this.taxesToDisable + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.itemIds);
        builder.taxesToEnable = this.internalGetTaxesToEnable();
        builder.taxesToDisable = this.internalGetTaxesToDisable();
        return builder;
    }

    public static class Builder {
        private List<String> itemIds;
        private OptionalNullable<List<String>> taxesToEnable;
        private OptionalNullable<List<String>> taxesToDisable;

        public Builder(List<String> itemIds) {
            this.itemIds = itemIds;
        }

        public Builder itemIds(List<String> itemIds) {
            this.itemIds = itemIds;
            return this;
        }

        public Builder taxesToEnable(List<String> taxesToEnable) {
            this.taxesToEnable = OptionalNullable.of(taxesToEnable);
            return this;
        }

        public Builder unsetTaxesToEnable() {
            this.taxesToEnable = null;
            return this;
        }

        public Builder taxesToDisable(List<String> taxesToDisable) {
            this.taxesToDisable = OptionalNullable.of(taxesToDisable);
            return this;
        }

        public Builder unsetTaxesToDisable() {
            this.taxesToDisable = null;
            return this;
        }

        public UpdateItemTaxesRequest build() {
            return new UpdateItemTaxesRequest(this.itemIds, this.taxesToEnable, this.taxesToDisable);
        }
    }
}

