/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Order;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class UpdateOrderRequest {
    private final Order order;
    private final OptionalNullable<List<String>> fieldsToClear;
    private final OptionalNullable<String> idempotencyKey;

    @JsonCreator
    public UpdateOrderRequest(@JsonProperty(value="order") Order order, @JsonProperty(value="fields_to_clear") List<String> fieldsToClear, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.order = order;
        this.fieldsToClear = OptionalNullable.of(fieldsToClear);
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
    }

    protected UpdateOrderRequest(Order order, OptionalNullable<List<String>> fieldsToClear, OptionalNullable<String> idempotencyKey) {
        this.order = order;
        this.fieldsToClear = fieldsToClear;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="fields_to_clear")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetFieldsToClear() {
        return this.fieldsToClear;
    }

    @JsonIgnore
    public List<String> getFieldsToClear() {
        return (List)OptionalNullable.getFrom(this.fieldsToClear);
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.fieldsToClear, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateOrderRequest)) {
            return false;
        }
        UpdateOrderRequest other = (UpdateOrderRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.fieldsToClear, other.fieldsToClear) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "UpdateOrderRequest [order=" + this.order + ", fieldsToClear=" + this.fieldsToClear + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder());
        builder.fieldsToClear = this.internalGetFieldsToClear();
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private Order order;
        private OptionalNullable<List<String>> fieldsToClear;
        private OptionalNullable<String> idempotencyKey;

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder fieldsToClear(List<String> fieldsToClear) {
            this.fieldsToClear = OptionalNullable.of(fieldsToClear);
            return this;
        }

        public Builder unsetFieldsToClear() {
            this.fieldsToClear = null;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public UpdateOrderRequest build() {
            return new UpdateOrderRequest(this.order, this.fieldsToClear, this.idempotencyKey);
        }
    }
}

