/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TeamMember;
import java.util.List;
import java.util.Objects;

public class UpdateTeamMemberResponse {
    private HttpContext httpContext;
    private final TeamMember teamMember;
    private final List<Error> errors;

    @JsonCreator
    public UpdateTeamMemberResponse(@JsonProperty(value="team_member") TeamMember teamMember, @JsonProperty(value="errors") List<Error> errors) {
        this.teamMember = teamMember;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="team_member")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TeamMember getTeamMember() {
        return this.teamMember;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.teamMember, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateTeamMemberResponse)) {
            return false;
        }
        UpdateTeamMemberResponse other = (UpdateTeamMemberResponse)obj;
        return Objects.equals(this.teamMember, other.teamMember) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "UpdateTeamMemberResponse [teamMember=" + this.teamMember + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMember(this.getTeamMember()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private TeamMember teamMember;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder teamMember(TeamMember teamMember) {
            this.teamMember = teamMember;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public UpdateTeamMemberResponse build() {
            UpdateTeamMemberResponse model = new UpdateTeamMemberResponse(this.teamMember, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

