/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomAttribute;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class UpsertBookingCustomAttributeRequest {
    private final CustomAttribute customAttribute;
    private final OptionalNullable<String> idempotencyKey;

    @JsonCreator
    public UpsertBookingCustomAttributeRequest(@JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.customAttribute = customAttribute;
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
    }

    protected UpsertBookingCustomAttributeRequest(CustomAttribute customAttribute, OptionalNullable<String> idempotencyKey) {
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.customAttribute, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpsertBookingCustomAttributeRequest)) {
            return false;
        }
        UpsertBookingCustomAttributeRequest other = (UpsertBookingCustomAttributeRequest)obj;
        return Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "UpsertBookingCustomAttributeRequest [customAttribute=" + this.customAttribute + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.customAttribute);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private CustomAttribute customAttribute;
        private OptionalNullable<String> idempotencyKey;

        public Builder(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public UpsertBookingCustomAttributeRequest build() {
            return new UpsertBookingCustomAttributeRequest(this.customAttribute, this.idempotencyKey);
        }
    }
}

