/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1ListOrdersRequest {
    private final String order;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> batchToken;

    @JsonCreator
    public V1ListOrdersRequest(@JsonProperty(value="order") String order, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="batch_token") String batchToken) {
        this.order = order;
        this.limit = OptionalNullable.of((Object)limit);
        this.batchToken = OptionalNullable.of((Object)batchToken);
    }

    protected V1ListOrdersRequest(String order, OptionalNullable<Integer> limit, OptionalNullable<String> batchToken) {
        this.order = order;
        this.limit = limit;
        this.batchToken = batchToken;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrder() {
        return this.order;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="batch_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBatchToken() {
        return this.batchToken;
    }

    @JsonIgnore
    public String getBatchToken() {
        return (String)OptionalNullable.getFrom(this.batchToken);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.limit, this.batchToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1ListOrdersRequest)) {
            return false;
        }
        V1ListOrdersRequest other = (V1ListOrdersRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.limit, other.limit) && Objects.equals(this.batchToken, other.batchToken);
    }

    public String toString() {
        return "V1ListOrdersRequest [order=" + this.order + ", limit=" + this.limit + ", batchToken=" + this.batchToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder());
        builder.limit = this.internalGetLimit();
        builder.batchToken = this.internalGetBatchToken();
        return builder;
    }

    public static class Builder {
        private String order;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> batchToken;

        public Builder order(String order) {
            this.order = order;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder batchToken(String batchToken) {
            this.batchToken = OptionalNullable.of((Object)batchToken);
            return this;
        }

        public Builder unsetBatchToken() {
            this.batchToken = null;
            return this;
        }

        public V1ListOrdersRequest build() {
            return new V1ListOrdersRequest(this.order, this.limit, this.batchToken);
        }
    }
}

