/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1ListPaymentsRequest {
    private final String order;
    private final OptionalNullable<String> beginTime;
    private final OptionalNullable<String> endTime;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> batchToken;
    private final OptionalNullable<Boolean> includePartial;

    @JsonCreator
    public V1ListPaymentsRequest(@JsonProperty(value="order") String order, @JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="batch_token") String batchToken, @JsonProperty(value="include_partial") Boolean includePartial) {
        this.order = order;
        this.beginTime = OptionalNullable.of((Object)beginTime);
        this.endTime = OptionalNullable.of((Object)endTime);
        this.limit = OptionalNullable.of((Object)limit);
        this.batchToken = OptionalNullable.of((Object)batchToken);
        this.includePartial = OptionalNullable.of((Object)includePartial);
    }

    protected V1ListPaymentsRequest(String order, OptionalNullable<String> beginTime, OptionalNullable<String> endTime, OptionalNullable<Integer> limit, OptionalNullable<String> batchToken, OptionalNullable<Boolean> includePartial) {
        this.order = order;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.limit = limit;
        this.batchToken = batchToken;
        this.includePartial = includePartial;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrder() {
        return this.order;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBeginTime() {
        return this.beginTime;
    }

    @JsonIgnore
    public String getBeginTime() {
        return (String)OptionalNullable.getFrom(this.beginTime);
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndTime() {
        return this.endTime;
    }

    @JsonIgnore
    public String getEndTime() {
        return (String)OptionalNullable.getFrom(this.endTime);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="batch_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBatchToken() {
        return this.batchToken;
    }

    @JsonIgnore
    public String getBatchToken() {
        return (String)OptionalNullable.getFrom(this.batchToken);
    }

    @JsonGetter(value="include_partial")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludePartial() {
        return this.includePartial;
    }

    @JsonIgnore
    public Boolean getIncludePartial() {
        return (Boolean)OptionalNullable.getFrom(this.includePartial);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.beginTime, this.endTime, this.limit, this.batchToken, this.includePartial);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1ListPaymentsRequest)) {
            return false;
        }
        V1ListPaymentsRequest other = (V1ListPaymentsRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.limit, other.limit) && Objects.equals(this.batchToken, other.batchToken) && Objects.equals(this.includePartial, other.includePartial);
    }

    public String toString() {
        return "V1ListPaymentsRequest [order=" + this.order + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", batchToken=" + this.batchToken + ", includePartial=" + this.includePartial + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder());
        builder.beginTime = this.internalGetBeginTime();
        builder.endTime = this.internalGetEndTime();
        builder.limit = this.internalGetLimit();
        builder.batchToken = this.internalGetBatchToken();
        builder.includePartial = this.internalGetIncludePartial();
        return builder;
    }

    public static class Builder {
        private String order;
        private OptionalNullable<String> beginTime;
        private OptionalNullable<String> endTime;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> batchToken;
        private OptionalNullable<Boolean> includePartial;

        public Builder order(String order) {
            this.order = order;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = OptionalNullable.of((Object)beginTime);
            return this;
        }

        public Builder unsetBeginTime() {
            this.beginTime = null;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = OptionalNullable.of((Object)endTime);
            return this;
        }

        public Builder unsetEndTime() {
            this.endTime = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder batchToken(String batchToken) {
            this.batchToken = OptionalNullable.of((Object)batchToken);
            return this;
        }

        public Builder unsetBatchToken() {
            this.batchToken = null;
            return this;
        }

        public Builder includePartial(Boolean includePartial) {
            this.includePartial = OptionalNullable.of((Object)includePartial);
            return this;
        }

        public Builder unsetIncludePartial() {
            this.includePartial = null;
            return this;
        }

        public V1ListPaymentsRequest build() {
            return new V1ListPaymentsRequest(this.order, this.beginTime, this.endTime, this.limit, this.batchToken, this.includePartial);
        }
    }
}

