/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.V1Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1PaymentDiscount {
    private final OptionalNullable<String> name;
    private final V1Money appliedMoney;
    private final OptionalNullable<String> discountId;

    @JsonCreator
    public V1PaymentDiscount(@JsonProperty(value="name") String name, @JsonProperty(value="applied_money") V1Money appliedMoney, @JsonProperty(value="discount_id") String discountId) {
        this.name = OptionalNullable.of((Object)name);
        this.appliedMoney = appliedMoney;
        this.discountId = OptionalNullable.of((Object)discountId);
    }

    protected V1PaymentDiscount(OptionalNullable<String> name, V1Money appliedMoney, OptionalNullable<String> discountId) {
        this.name = name;
        this.appliedMoney = appliedMoney;
        this.discountId = discountId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="discount_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDiscountId() {
        return this.discountId;
    }

    @JsonIgnore
    public String getDiscountId() {
        return (String)OptionalNullable.getFrom(this.discountId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.appliedMoney, this.discountId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1PaymentDiscount)) {
            return false;
        }
        V1PaymentDiscount other = (V1PaymentDiscount)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.discountId, other.discountId);
    }

    public String toString() {
        return "V1PaymentDiscount [name=" + this.name + ", appliedMoney=" + this.appliedMoney + ", discountId=" + this.discountId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().appliedMoney(this.getAppliedMoney());
        builder.name = this.internalGetName();
        builder.discountId = this.internalGetDiscountId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private V1Money appliedMoney;
        private OptionalNullable<String> discountId;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder appliedMoney(V1Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder discountId(String discountId) {
            this.discountId = OptionalNullable.of((Object)discountId);
            return this;
        }

        public Builder unsetDiscountId() {
            this.discountId = null;
            return this;
        }

        public V1PaymentDiscount build() {
            return new V1PaymentDiscount(this.name, this.appliedMoney, this.discountId);
        }
    }
}

