/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class V1UpdateOrderRequest {
    private final String action;
    private final OptionalNullable<String> shippedTrackingNumber;
    private final OptionalNullable<String> completedNote;
    private final OptionalNullable<String> refundedNote;
    private final OptionalNullable<String> canceledNote;

    @JsonCreator
    public V1UpdateOrderRequest(@JsonProperty(value="action") String action, @JsonProperty(value="shipped_tracking_number") String shippedTrackingNumber, @JsonProperty(value="completed_note") String completedNote, @JsonProperty(value="refunded_note") String refundedNote, @JsonProperty(value="canceled_note") String canceledNote) {
        this.action = action;
        this.shippedTrackingNumber = OptionalNullable.of((Object)shippedTrackingNumber);
        this.completedNote = OptionalNullable.of((Object)completedNote);
        this.refundedNote = OptionalNullable.of((Object)refundedNote);
        this.canceledNote = OptionalNullable.of((Object)canceledNote);
    }

    protected V1UpdateOrderRequest(String action, OptionalNullable<String> shippedTrackingNumber, OptionalNullable<String> completedNote, OptionalNullable<String> refundedNote, OptionalNullable<String> canceledNote) {
        this.action = action;
        this.shippedTrackingNumber = shippedTrackingNumber;
        this.completedNote = completedNote;
        this.refundedNote = refundedNote;
        this.canceledNote = canceledNote;
    }

    @JsonGetter(value="action")
    public String getAction() {
        return this.action;
    }

    @JsonGetter(value="shipped_tracking_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetShippedTrackingNumber() {
        return this.shippedTrackingNumber;
    }

    @JsonIgnore
    public String getShippedTrackingNumber() {
        return (String)OptionalNullable.getFrom(this.shippedTrackingNumber);
    }

    @JsonGetter(value="completed_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCompletedNote() {
        return this.completedNote;
    }

    @JsonIgnore
    public String getCompletedNote() {
        return (String)OptionalNullable.getFrom(this.completedNote);
    }

    @JsonGetter(value="refunded_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRefundedNote() {
        return this.refundedNote;
    }

    @JsonIgnore
    public String getRefundedNote() {
        return (String)OptionalNullable.getFrom(this.refundedNote);
    }

    @JsonGetter(value="canceled_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCanceledNote() {
        return this.canceledNote;
    }

    @JsonIgnore
    public String getCanceledNote() {
        return (String)OptionalNullable.getFrom(this.canceledNote);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.shippedTrackingNumber, this.completedNote, this.refundedNote, this.canceledNote);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1UpdateOrderRequest)) {
            return false;
        }
        V1UpdateOrderRequest other = (V1UpdateOrderRequest)obj;
        return Objects.equals(this.action, other.action) && Objects.equals(this.shippedTrackingNumber, other.shippedTrackingNumber) && Objects.equals(this.completedNote, other.completedNote) && Objects.equals(this.refundedNote, other.refundedNote) && Objects.equals(this.canceledNote, other.canceledNote);
    }

    public String toString() {
        return "V1UpdateOrderRequest [action=" + this.action + ", shippedTrackingNumber=" + this.shippedTrackingNumber + ", completedNote=" + this.completedNote + ", refundedNote=" + this.refundedNote + ", canceledNote=" + this.canceledNote + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.action);
        builder.shippedTrackingNumber = this.internalGetShippedTrackingNumber();
        builder.completedNote = this.internalGetCompletedNote();
        builder.refundedNote = this.internalGetRefundedNote();
        builder.canceledNote = this.internalGetCanceledNote();
        return builder;
    }

    public static class Builder {
        private String action;
        private OptionalNullable<String> shippedTrackingNumber;
        private OptionalNullable<String> completedNote;
        private OptionalNullable<String> refundedNote;
        private OptionalNullable<String> canceledNote;

        public Builder(String action) {
            this.action = action;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder shippedTrackingNumber(String shippedTrackingNumber) {
            this.shippedTrackingNumber = OptionalNullable.of((Object)shippedTrackingNumber);
            return this;
        }

        public Builder unsetShippedTrackingNumber() {
            this.shippedTrackingNumber = null;
            return this;
        }

        public Builder completedNote(String completedNote) {
            this.completedNote = OptionalNullable.of((Object)completedNote);
            return this;
        }

        public Builder unsetCompletedNote() {
            this.completedNote = null;
            return this;
        }

        public Builder refundedNote(String refundedNote) {
            this.refundedNote = OptionalNullable.of((Object)refundedNote);
            return this;
        }

        public Builder unsetRefundedNote() {
            this.refundedNote = null;
            return this;
        }

        public Builder canceledNote(String canceledNote) {
            this.canceledNote = OptionalNullable.of((Object)canceledNote);
            return this;
        }

        public Builder unsetCanceledNote() {
            this.canceledNote = null;
            return this;
        }

        public V1UpdateOrderRequest build() {
            return new V1UpdateOrderRequest(this.action, this.shippedTrackingNumber, this.completedNote, this.refundedNote, this.canceledNote);
        }
    }
}

