/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class VendorContact {
    private final String id;
    private final OptionalNullable<String> name;
    private final OptionalNullable<String> emailAddress;
    private final OptionalNullable<String> phoneNumber;
    private final OptionalNullable<Boolean> removed;
    private final int ordinal;

    @JsonCreator
    public VendorContact(@JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="removed") Boolean removed) {
        this.id = id;
        this.name = OptionalNullable.of((Object)name);
        this.emailAddress = OptionalNullable.of((Object)emailAddress);
        this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
        this.removed = OptionalNullable.of((Object)removed);
        this.ordinal = ordinal;
    }

    protected VendorContact(int ordinal, String id, OptionalNullable<String> name, OptionalNullable<String> emailAddress, OptionalNullable<String> phoneNumber, OptionalNullable<Boolean> removed) {
        this.id = id;
        this.name = name;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.removed = removed;
        this.ordinal = ordinal;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public String getEmailAddress() {
        return (String)OptionalNullable.getFrom(this.emailAddress);
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public String getPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.phoneNumber);
    }

    @JsonGetter(value="removed")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetRemoved() {
        return this.removed;
    }

    @JsonIgnore
    public Boolean getRemoved() {
        return (Boolean)OptionalNullable.getFrom(this.removed);
    }

    @JsonGetter(value="ordinal")
    public int getOrdinal() {
        return this.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.emailAddress, this.phoneNumber, this.removed, this.ordinal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VendorContact)) {
            return false;
        }
        VendorContact other = (VendorContact)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.removed, other.removed) && Objects.equals(this.ordinal, other.ordinal);
    }

    public String toString() {
        return "VendorContact [ordinal=" + this.ordinal + ", id=" + this.id + ", name=" + this.name + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", removed=" + this.removed + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.ordinal).id(this.getId());
        builder.name = this.internalGetName();
        builder.emailAddress = this.internalGetEmailAddress();
        builder.phoneNumber = this.internalGetPhoneNumber();
        builder.removed = this.internalGetRemoved();
        return builder;
    }

    public static class Builder {
        private int ordinal;
        private String id;
        private OptionalNullable<String> name;
        private OptionalNullable<String> emailAddress;
        private OptionalNullable<String> phoneNumber;
        private OptionalNullable<Boolean> removed;

        public Builder(int ordinal) {
            this.ordinal = ordinal;
        }

        public Builder ordinal(int ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = OptionalNullable.of((Object)emailAddress);
            return this;
        }

        public Builder unsetEmailAddress() {
            this.emailAddress = null;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
            return this;
        }

        public Builder unsetPhoneNumber() {
            this.phoneNumber = null;
            return this;
        }

        public Builder removed(Boolean removed) {
            this.removed = OptionalNullable.of((Object)removed);
            return this;
        }

        public Builder unsetRemoved() {
            this.removed = null;
            return this;
        }

        public VendorContact build() {
            return new VendorContact(this.ordinal, this.id, this.name, this.emailAddress, this.phoneNumber, this.removed);
        }
    }
}

