/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.utilities;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class WebhooksHelper {
    private static final String HMAC_SHA_256 = "HmacSHA256";

    public static boolean isValidWebhookEventSignature(String requestBody, String signatureHeader, String signatureKey, String notificationUrl) {
        Mac mac;
        if (requestBody == null) {
            return false;
        }
        if (signatureKey == null || signatureKey.isEmpty()) {
            throw new IllegalArgumentException("signatureKey is null or empty");
        }
        if (notificationUrl == null || notificationUrl.isEmpty()) {
            throw new IllegalArgumentException("notificationUrl is null or empty");
        }
        String payload = notificationUrl.concat(requestBody);
        byte[] payloadBytes = payload.getBytes(StandardCharsets.UTF_8);
        byte[] signatureKeyBytes = signatureKey.getBytes(StandardCharsets.UTF_8);
        try {
            mac = Mac.getInstance(HMAC_SHA_256);
            SecretKeySpec secret = new SecretKeySpec(signatureKeyBytes, HMAC_SHA_256);
            mac.init(secret);
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
            return false;
        }
        byte[] hashBytes = mac.doFinal(payloadBytes);
        String hashString = Base64.getEncoder().encodeToString(hashBytes);
        return hashString.equals(signatureHeader);
    }
}

