
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

/**
 * This is a model class for DestinationDetailsCardRefundDetails type.
 */
public class DestinationDetailsCardRefundDetails {
    private final Card card;
    private final OptionalNullable<String> entryMethod;

    /**
     * Initialization constructor.
     * @param  card  Card value for card.
     * @param  entryMethod  String value for entryMethod.
     */
    @JsonCreator
    public DestinationDetailsCardRefundDetails(
            @JsonProperty("card") Card card,
            @JsonProperty("entry_method") String entryMethod) {
        this.card = card;
        this.entryMethod = OptionalNullable.of(entryMethod);
    }

    /**
     * Initialization constructor.
     * @param  card  Card value for card.
     * @param  entryMethod  String value for entryMethod.
     */

    protected DestinationDetailsCardRefundDetails(Card card,
            OptionalNullable<String> entryMethod) {
        this.card = card;
        this.entryMethod = entryMethod;
    }

    /**
     * Getter for Card.
     * Represents the payment details of a card to be used for payments. These details are
     * determined by the payment token generated by Web Payments SDK.
     * @return Returns the Card
     */
    @JsonGetter("card")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Card getCard() {
        return card;
    }

    /**
     * Internal Getter for EntryMethod.
     * The method used to enter the card's details for the refund. The method can be `KEYED`,
     * `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     * @return Returns the Internal String
     */
    @JsonGetter("entry_method")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonSerialize(using = OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEntryMethod() {
        return this.entryMethod;
    }

    /**
     * Getter for EntryMethod.
     * The method used to enter the card's details for the refund. The method can be `KEYED`,
     * `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     * @return Returns the String
     */
    @JsonIgnore
    public String getEntryMethod() {
        return OptionalNullable.getFrom(entryMethod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(card, entryMethod);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DestinationDetailsCardRefundDetails)) {
            return false;
        }
        DestinationDetailsCardRefundDetails other = (DestinationDetailsCardRefundDetails) obj;
        return Objects.equals(card, other.card)
            && Objects.equals(entryMethod, other.entryMethod);
    }

    /**
     * Converts this DestinationDetailsCardRefundDetails into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "DestinationDetailsCardRefundDetails [" + "card=" + card + ", entryMethod="
                + entryMethod + "]";
    }

    /**
     * Builds a new {@link DestinationDetailsCardRefundDetails.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link DestinationDetailsCardRefundDetails.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .card(getCard());
        builder.entryMethod = internalGetEntryMethod();
        return builder;
    }

    /**
     * Class to build instances of {@link DestinationDetailsCardRefundDetails}.
     */
    public static class Builder {
        private Card card;
        private OptionalNullable<String> entryMethod;



        /**
         * Setter for card.
         * @param  card  Card value for card.
         * @return Builder
         */
        public Builder card(Card card) {
            this.card = card;
            return this;
        }

        /**
         * Setter for entryMethod.
         * @param  entryMethod  String value for entryMethod.
         * @return Builder
         */
        public Builder entryMethod(String entryMethod) {
            this.entryMethod = OptionalNullable.of(entryMethod);
            return this;
        }

        /**
         * UnSetter for entryMethod.
         * @return Builder
         */
        public Builder unsetEntryMethod() {
            entryMethod = null;
            return this;
        }

        /**
         * Builds a new {@link DestinationDetailsCardRefundDetails} object using the set fields.
         * @return {@link DestinationDetailsCardRefundDetails}
         */
        public DestinationDetailsCardRefundDetails build() {
            return new DestinationDetailsCardRefundDetails(card, entryMethod);
        }
    }
}
