/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.ApiHelper;
import com.squareup.square.BearerAuthCredentials;
import com.squareup.square.BearerAuthManager;
import com.squareup.square.CompatibilityFactoryImpl;
import com.squareup.square.Environment;
import com.squareup.square.Server;
import com.squareup.square.SquareClientInterface;
import com.squareup.square.api.ApplePayApi;
import com.squareup.square.api.BankAccountsApi;
import com.squareup.square.api.BookingCustomAttributesApi;
import com.squareup.square.api.BookingsApi;
import com.squareup.square.api.CardsApi;
import com.squareup.square.api.CashDrawersApi;
import com.squareup.square.api.CatalogApi;
import com.squareup.square.api.CheckoutApi;
import com.squareup.square.api.CustomerCustomAttributesApi;
import com.squareup.square.api.CustomerGroupsApi;
import com.squareup.square.api.CustomerSegmentsApi;
import com.squareup.square.api.CustomersApi;
import com.squareup.square.api.DefaultApplePayApi;
import com.squareup.square.api.DefaultBankAccountsApi;
import com.squareup.square.api.DefaultBookingCustomAttributesApi;
import com.squareup.square.api.DefaultBookingsApi;
import com.squareup.square.api.DefaultCardsApi;
import com.squareup.square.api.DefaultCashDrawersApi;
import com.squareup.square.api.DefaultCatalogApi;
import com.squareup.square.api.DefaultCheckoutApi;
import com.squareup.square.api.DefaultCustomerCustomAttributesApi;
import com.squareup.square.api.DefaultCustomerGroupsApi;
import com.squareup.square.api.DefaultCustomerSegmentsApi;
import com.squareup.square.api.DefaultCustomersApi;
import com.squareup.square.api.DefaultDevicesApi;
import com.squareup.square.api.DefaultDisputesApi;
import com.squareup.square.api.DefaultEmployeesApi;
import com.squareup.square.api.DefaultGiftCardActivitiesApi;
import com.squareup.square.api.DefaultGiftCardsApi;
import com.squareup.square.api.DefaultInventoryApi;
import com.squareup.square.api.DefaultInvoicesApi;
import com.squareup.square.api.DefaultLaborApi;
import com.squareup.square.api.DefaultLocationCustomAttributesApi;
import com.squareup.square.api.DefaultLocationsApi;
import com.squareup.square.api.DefaultLoyaltyApi;
import com.squareup.square.api.DefaultMerchantCustomAttributesApi;
import com.squareup.square.api.DefaultMerchantsApi;
import com.squareup.square.api.DefaultMobileAuthorizationApi;
import com.squareup.square.api.DefaultOAuthApi;
import com.squareup.square.api.DefaultOrderCustomAttributesApi;
import com.squareup.square.api.DefaultOrdersApi;
import com.squareup.square.api.DefaultPaymentsApi;
import com.squareup.square.api.DefaultPayoutsApi;
import com.squareup.square.api.DefaultRefundsApi;
import com.squareup.square.api.DefaultSitesApi;
import com.squareup.square.api.DefaultSnippetsApi;
import com.squareup.square.api.DefaultSubscriptionsApi;
import com.squareup.square.api.DefaultTeamApi;
import com.squareup.square.api.DefaultTerminalApi;
import com.squareup.square.api.DefaultTransactionsApi;
import com.squareup.square.api.DefaultV1TransactionsApi;
import com.squareup.square.api.DefaultVendorsApi;
import com.squareup.square.api.DefaultWebhookSubscriptionsApi;
import com.squareup.square.api.DevicesApi;
import com.squareup.square.api.DisputesApi;
import com.squareup.square.api.EmployeesApi;
import com.squareup.square.api.GiftCardActivitiesApi;
import com.squareup.square.api.GiftCardsApi;
import com.squareup.square.api.InventoryApi;
import com.squareup.square.api.InvoicesApi;
import com.squareup.square.api.LaborApi;
import com.squareup.square.api.LocationCustomAttributesApi;
import com.squareup.square.api.LocationsApi;
import com.squareup.square.api.LoyaltyApi;
import com.squareup.square.api.MerchantCustomAttributesApi;
import com.squareup.square.api.MerchantsApi;
import com.squareup.square.api.MobileAuthorizationApi;
import com.squareup.square.api.OAuthApi;
import com.squareup.square.api.OrderCustomAttributesApi;
import com.squareup.square.api.OrdersApi;
import com.squareup.square.api.PaymentsApi;
import com.squareup.square.api.PayoutsApi;
import com.squareup.square.api.RefundsApi;
import com.squareup.square.api.SitesApi;
import com.squareup.square.api.SnippetsApi;
import com.squareup.square.api.SubscriptionsApi;
import com.squareup.square.api.TeamApi;
import com.squareup.square.api.TerminalApi;
import com.squareup.square.api.TransactionsApi;
import com.squareup.square.api.V1TransactionsApi;
import com.squareup.square.api.VendorsApi;
import com.squareup.square.api.WebhookSubscriptionsApi;
import com.squareup.square.http.Headers;
import com.squareup.square.http.client.HttpCallback;
import com.squareup.square.http.client.HttpClientConfiguration;
import com.squareup.square.http.client.ReadonlyHttpClientConfiguration;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.authentication.Authentication;
import io.apimatic.coreinterfaces.compatibility.CompatibilityFactory;
import io.apimatic.coreinterfaces.http.Callback;
import io.apimatic.coreinterfaces.http.HttpClient;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.okhttpclient.adapter.OkClient;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class SquareClient
implements SquareClientInterface {
    private MobileAuthorizationApi mobileAuthorization;
    private OAuthApi oAuth;
    private V1TransactionsApi v1Transactions;
    private ApplePayApi applePay;
    private BankAccountsApi bankAccounts;
    private BookingsApi bookings;
    private BookingCustomAttributesApi bookingCustomAttributes;
    private CardsApi cards;
    private CashDrawersApi cashDrawers;
    private CatalogApi catalog;
    private CustomersApi customers;
    private CustomerCustomAttributesApi customerCustomAttributes;
    private CustomerGroupsApi customerGroups;
    private CustomerSegmentsApi customerSegments;
    private DevicesApi devices;
    private DisputesApi disputes;
    private EmployeesApi employees;
    private GiftCardsApi giftCards;
    private GiftCardActivitiesApi giftCardActivities;
    private InventoryApi inventory;
    private InvoicesApi invoices;
    private LaborApi labor;
    private LocationsApi locations;
    private LocationCustomAttributesApi locationCustomAttributes;
    private CheckoutApi checkout;
    private TransactionsApi transactions;
    private LoyaltyApi loyalty;
    private MerchantsApi merchants;
    private MerchantCustomAttributesApi merchantCustomAttributes;
    private OrdersApi orders;
    private OrderCustomAttributesApi orderCustomAttributes;
    private PaymentsApi payments;
    private PayoutsApi payouts;
    private RefundsApi refunds;
    private SitesApi sites;
    private SnippetsApi snippets;
    private SubscriptionsApi subscriptions;
    private TeamApi team;
    private TerminalApi terminal;
    private VendorsApi vendors;
    private WebhookSubscriptionsApi webhookSubscriptions;
    private static final CompatibilityFactory compatibilityFactory = new CompatibilityFactoryImpl();
    private static String userAgent = "Square-Java-SDK/37.0.0.20240118 ({api-version}) {engine}/{engine-version} ({os-info}) {detail}";
    private final Environment environment;
    private final String customUrl;
    private final String squareVersion;
    private final HttpClient httpClient;
    private final ReadonlyHttpClientConfiguration httpClientConfig;
    private final Headers additionalHeaders;
    private final String userAgentDetail;
    private BearerAuthManager bearerAuthManager;
    private Map<String, Authentication> authentications;
    private final HttpCallback httpCallback;

    private SquareClient(Environment environment, String customUrl, String squareVersion, HttpClient httpClient, ReadonlyHttpClientConfiguration httpClientConfig, Headers additionalHeaders, String userAgentDetail, String accessToken, Map<String, Authentication> authentications, HttpCallback httpCallback) {
        this.environment = environment;
        this.customUrl = customUrl;
        this.squareVersion = squareVersion;
        this.httpClient = httpClient;
        this.httpClientConfig = httpClientConfig;
        this.additionalHeaders = additionalHeaders;
        this.userAgentDetail = userAgentDetail;
        this.httpCallback = httpCallback;
        this.authentications = authentications == null ? new HashMap<String, Authentication>() : new HashMap<String, Authentication>(authentications);
        HashMap<String, String> userAgentConfig = new HashMap<String, String>();
        userAgentConfig.put("{api-version}", squareVersion != null ? squareVersion : "");
        userAgentConfig.put("{detail}", userAgentDetail != null ? ApiHelper.tryUrlEncode((String)userAgentDetail, (boolean)true) : "");
        if (this.authentications.containsKey("global")) {
            this.bearerAuthManager = (BearerAuthManager)this.authentications.get("global");
        }
        if (!this.authentications.containsKey("global") || !this.getBearerAuthCredentials().equals(accessToken)) {
            this.bearerAuthManager = new BearerAuthManager(accessToken);
            this.authentications.put("global", (Authentication)this.bearerAuthManager);
        }
        GlobalConfiguration globalConfig = new GlobalConfiguration.Builder().authentication(this.authentications).compatibilityFactory(compatibilityFactory).httpClient(httpClient).baseUri(server -> this.getBaseUri((String)server)).callback((Callback)httpCallback).userAgent(userAgent).userAgentConfig(userAgentConfig).additionalHeaders((HttpHeaders)additionalHeaders).globalHeader("Square-Version", squareVersion).build();
        this.mobileAuthorization = new DefaultMobileAuthorizationApi(globalConfig);
        this.oAuth = new DefaultOAuthApi(globalConfig);
        this.v1Transactions = new DefaultV1TransactionsApi(globalConfig);
        this.applePay = new DefaultApplePayApi(globalConfig);
        this.bankAccounts = new DefaultBankAccountsApi(globalConfig);
        this.bookings = new DefaultBookingsApi(globalConfig);
        this.bookingCustomAttributes = new DefaultBookingCustomAttributesApi(globalConfig);
        this.cards = new DefaultCardsApi(globalConfig);
        this.cashDrawers = new DefaultCashDrawersApi(globalConfig);
        this.catalog = new DefaultCatalogApi(globalConfig);
        this.customers = new DefaultCustomersApi(globalConfig);
        this.customerCustomAttributes = new DefaultCustomerCustomAttributesApi(globalConfig);
        this.customerGroups = new DefaultCustomerGroupsApi(globalConfig);
        this.customerSegments = new DefaultCustomerSegmentsApi(globalConfig);
        this.devices = new DefaultDevicesApi(globalConfig);
        this.disputes = new DefaultDisputesApi(globalConfig);
        this.employees = new DefaultEmployeesApi(globalConfig);
        this.giftCards = new DefaultGiftCardsApi(globalConfig);
        this.giftCardActivities = new DefaultGiftCardActivitiesApi(globalConfig);
        this.inventory = new DefaultInventoryApi(globalConfig);
        this.invoices = new DefaultInvoicesApi(globalConfig);
        this.labor = new DefaultLaborApi(globalConfig);
        this.locations = new DefaultLocationsApi(globalConfig);
        this.locationCustomAttributes = new DefaultLocationCustomAttributesApi(globalConfig);
        this.checkout = new DefaultCheckoutApi(globalConfig);
        this.transactions = new DefaultTransactionsApi(globalConfig);
        this.loyalty = new DefaultLoyaltyApi(globalConfig);
        this.merchants = new DefaultMerchantsApi(globalConfig);
        this.merchantCustomAttributes = new DefaultMerchantCustomAttributesApi(globalConfig);
        this.orders = new DefaultOrdersApi(globalConfig);
        this.orderCustomAttributes = new DefaultOrderCustomAttributesApi(globalConfig);
        this.payments = new DefaultPaymentsApi(globalConfig);
        this.payouts = new DefaultPayoutsApi(globalConfig);
        this.refunds = new DefaultRefundsApi(globalConfig);
        this.sites = new DefaultSitesApi(globalConfig);
        this.snippets = new DefaultSnippetsApi(globalConfig);
        this.subscriptions = new DefaultSubscriptionsApi(globalConfig);
        this.team = new DefaultTeamApi(globalConfig);
        this.terminal = new DefaultTerminalApi(globalConfig);
        this.vendors = new DefaultVendorsApi(globalConfig);
        this.webhookSubscriptions = new DefaultWebhookSubscriptionsApi(globalConfig);
    }

    public static void shutdown() {
        OkClient.shutdown();
    }

    @Override
    public MobileAuthorizationApi getMobileAuthorizationApi() {
        return this.mobileAuthorization;
    }

    @Override
    public OAuthApi getOAuthApi() {
        return this.oAuth;
    }

    @Override
    public V1TransactionsApi getV1TransactionsApi() {
        return this.v1Transactions;
    }

    @Override
    public ApplePayApi getApplePayApi() {
        return this.applePay;
    }

    @Override
    public BankAccountsApi getBankAccountsApi() {
        return this.bankAccounts;
    }

    @Override
    public BookingsApi getBookingsApi() {
        return this.bookings;
    }

    @Override
    public BookingCustomAttributesApi getBookingCustomAttributesApi() {
        return this.bookingCustomAttributes;
    }

    @Override
    public CardsApi getCardsApi() {
        return this.cards;
    }

    @Override
    public CashDrawersApi getCashDrawersApi() {
        return this.cashDrawers;
    }

    @Override
    public CatalogApi getCatalogApi() {
        return this.catalog;
    }

    @Override
    public CustomersApi getCustomersApi() {
        return this.customers;
    }

    @Override
    public CustomerCustomAttributesApi getCustomerCustomAttributesApi() {
        return this.customerCustomAttributes;
    }

    @Override
    public CustomerGroupsApi getCustomerGroupsApi() {
        return this.customerGroups;
    }

    @Override
    public CustomerSegmentsApi getCustomerSegmentsApi() {
        return this.customerSegments;
    }

    @Override
    public DevicesApi getDevicesApi() {
        return this.devices;
    }

    @Override
    public DisputesApi getDisputesApi() {
        return this.disputes;
    }

    @Override
    public EmployeesApi getEmployeesApi() {
        return this.employees;
    }

    @Override
    public GiftCardsApi getGiftCardsApi() {
        return this.giftCards;
    }

    @Override
    public GiftCardActivitiesApi getGiftCardActivitiesApi() {
        return this.giftCardActivities;
    }

    @Override
    public InventoryApi getInventoryApi() {
        return this.inventory;
    }

    @Override
    public InvoicesApi getInvoicesApi() {
        return this.invoices;
    }

    @Override
    public LaborApi getLaborApi() {
        return this.labor;
    }

    @Override
    public LocationsApi getLocationsApi() {
        return this.locations;
    }

    @Override
    public LocationCustomAttributesApi getLocationCustomAttributesApi() {
        return this.locationCustomAttributes;
    }

    @Override
    public CheckoutApi getCheckoutApi() {
        return this.checkout;
    }

    @Override
    public TransactionsApi getTransactionsApi() {
        return this.transactions;
    }

    @Override
    public LoyaltyApi getLoyaltyApi() {
        return this.loyalty;
    }

    @Override
    public MerchantsApi getMerchantsApi() {
        return this.merchants;
    }

    @Override
    public MerchantCustomAttributesApi getMerchantCustomAttributesApi() {
        return this.merchantCustomAttributes;
    }

    @Override
    public OrdersApi getOrdersApi() {
        return this.orders;
    }

    @Override
    public OrderCustomAttributesApi getOrderCustomAttributesApi() {
        return this.orderCustomAttributes;
    }

    @Override
    public PaymentsApi getPaymentsApi() {
        return this.payments;
    }

    @Override
    public PayoutsApi getPayoutsApi() {
        return this.payouts;
    }

    @Override
    public RefundsApi getRefundsApi() {
        return this.refunds;
    }

    @Override
    public SitesApi getSitesApi() {
        return this.sites;
    }

    @Override
    public SnippetsApi getSnippetsApi() {
        return this.snippets;
    }

    @Override
    public SubscriptionsApi getSubscriptionsApi() {
        return this.subscriptions;
    }

    @Override
    public TeamApi getTeamApi() {
        return this.team;
    }

    @Override
    public TerminalApi getTerminalApi() {
        return this.terminal;
    }

    @Override
    public VendorsApi getVendorsApi() {
        return this.vendors;
    }

    @Override
    public WebhookSubscriptionsApi getWebhookSubscriptionsApi() {
        return this.webhookSubscriptions;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getCustomUrl() {
        return this.customUrl;
    }

    @Override
    public String getSquareVersion() {
        return this.squareVersion;
    }

    private HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public ReadonlyHttpClientConfiguration getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @Override
    public Headers getAdditionalHeaders() {
        return new Headers(this.additionalHeaders);
    }

    @Override
    public String getUserAgentDetail() {
        return this.userAgentDetail;
    }

    private BearerAuthCredentials getBearerAuthCredentials() {
        return this.bearerAuthManager;
    }

    @Override
    public String getAccessToken() {
        return this.getBearerAuthCredentials().getAccessToken();
    }

    @Override
    public String getSdkVersion() {
        return "37.0.0.20240118";
    }

    @Override
    @Deprecated
    public long timeout() {
        return this.httpClientConfig.getTimeout();
    }

    @Override
    public String getBaseUri(Server server) {
        HashMap<String, AbstractMap.SimpleEntry<String, Boolean>> parameters = new HashMap<String, AbstractMap.SimpleEntry<String, Boolean>>();
        parameters.put("custom_url", new AbstractMap.SimpleEntry<String, Boolean>(this.customUrl, false));
        StringBuilder baseUrl = new StringBuilder(SquareClient.environmentMapper(this.environment, server));
        ApiHelper.appendUrlWithTemplateParameters((StringBuilder)baseUrl, parameters);
        return baseUrl.toString();
    }

    @Override
    public String getBaseUri() {
        return this.getBaseUri(Server.ENUM_DEFAULT);
    }

    public String getBaseUri(String server) {
        return this.getBaseUri(Server.fromString(server));
    }

    private static String environmentMapper(Environment environment, Server server) {
        if (environment.equals((Object)Environment.PRODUCTION) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "https://connect.squareup.com";
        }
        if (environment.equals((Object)Environment.SANDBOX) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "https://connect.squareupsandbox.com";
        }
        if (environment.equals((Object)Environment.CUSTOM) && server.equals((Object)Server.ENUM_DEFAULT)) {
            return "{custom_url}";
        }
        return "https://connect.squareup.com";
    }

    public String toString() {
        return "SquareClient [environment=" + (Object)((Object)this.environment) + ", customUrl=" + this.customUrl + ", squareVersion=" + this.squareVersion + ", httpClientConfig=" + this.httpClientConfig + ", additionalHeaders=" + this.additionalHeaders + ", userAgentDetail=" + this.userAgentDetail + ", authentications=" + this.authentications + "]";
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.environment = this.getEnvironment();
        builder.customUrl = this.getCustomUrl();
        builder.squareVersion = this.getSquareVersion();
        builder.httpClient = this.getHttpClient();
        builder.additionalHeaders = this.getAdditionalHeaders();
        builder.userAgentDetail = this.getUserAgentDetail();
        builder.accessToken = this.getBearerAuthCredentials().getAccessToken();
        builder.authentications = this.authentications;
        builder.httpCallback = this.httpCallback;
        builder.httpClientConfig(configBldr -> {
            configBldr = ((HttpClientConfiguration)this.httpClientConfig).newBuilder();
        });
        return builder;
    }

    public static class Builder {
        private Environment environment = Environment.PRODUCTION;
        private String customUrl = "https://connect.squareup.com";
        private String squareVersion = "2024-01-18";
        private HttpClient httpClient;
        private Headers additionalHeaders = new Headers();
        private String userAgentDetail = null;
        private String accessToken = "";
        private Map<String, Authentication> authentications = null;
        private HttpCallback httpCallback = null;
        private HttpClientConfiguration.Builder httpClientConfigBuilder = new HttpClientConfiguration.Builder();

        public Builder accessToken(String accessToken) {
            if (accessToken == null) {
                throw new NullPointerException("AccessToken cannot be null.");
            }
            this.accessToken = accessToken;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder customUrl(String customUrl) {
            this.customUrl = customUrl;
            return this;
        }

        public Builder squareVersion(String squareVersion) {
            if (squareVersion == null) {
                throw new NullPointerException("squareVersion cannot be null");
            }
            this.squareVersion = squareVersion;
            return this;
        }

        public Builder additionalHeaders(Headers additionalHeaders) {
            if (additionalHeaders == null) {
                throw new NullPointerException("additionalHeaders cannot be null");
            }
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        public Builder userAgentDetail(String userAgentDetail) {
            if (userAgentDetail != null && userAgentDetail.length() > 128) {
                throw new IllegalArgumentException("The length of user-agent detail should not exceed 128 characters.");
            }
            this.userAgentDetail = userAgentDetail;
            return this;
        }

        @Deprecated
        public Builder timeout(long timeout) {
            this.httpClientConfigBuilder.timeout(timeout);
            return this;
        }

        public Builder httpCallback(HttpCallback httpCallback) {
            this.httpCallback = httpCallback;
            return this;
        }

        public Builder httpClientConfig(Consumer<HttpClientConfiguration.Builder> action) {
            action.accept(this.httpClientConfigBuilder);
            return this;
        }

        public SquareClient build() {
            HttpClientConfiguration httpClientConfig = this.httpClientConfigBuilder.build();
            this.httpClient = new OkClient(httpClientConfig.getConfiguration(), compatibilityFactory);
            return new SquareClient(this.environment, this.customUrl, this.squareVersion, this.httpClient, httpClientConfig, this.additionalHeaders, this.userAgentDetail, this.accessToken, this.authentications, this.httpCallback);
        }
    }
}

