/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.BookingCustomAttributesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkDeleteBookingCustomAttributesRequest;
import com.squareup.square.models.BulkDeleteBookingCustomAttributesResponse;
import com.squareup.square.models.BulkUpsertBookingCustomAttributesRequest;
import com.squareup.square.models.BulkUpsertBookingCustomAttributesResponse;
import com.squareup.square.models.CreateBookingCustomAttributeDefinitionRequest;
import com.squareup.square.models.CreateBookingCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteBookingCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteBookingCustomAttributeResponse;
import com.squareup.square.models.ListBookingCustomAttributeDefinitionsResponse;
import com.squareup.square.models.ListBookingCustomAttributesResponse;
import com.squareup.square.models.RetrieveBookingCustomAttributeDefinitionResponse;
import com.squareup.square.models.RetrieveBookingCustomAttributeResponse;
import com.squareup.square.models.UpdateBookingCustomAttributeDefinitionRequest;
import com.squareup.square.models.UpdateBookingCustomAttributeDefinitionResponse;
import com.squareup.square.models.UpsertBookingCustomAttributeRequest;
import com.squareup.square.models.UpsertBookingCustomAttributeResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultBookingCustomAttributesApi
extends BaseApi
implements BookingCustomAttributesApi {
    public DefaultBookingCustomAttributesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListBookingCustomAttributeDefinitionsResponse listBookingCustomAttributeDefinitions(Integer limit, String cursor) throws ApiException, IOException {
        return (ListBookingCustomAttributeDefinitionsResponse)this.prepareListBookingCustomAttributeDefinitionsRequest(limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListBookingCustomAttributeDefinitionsResponse> listBookingCustomAttributeDefinitionsAsync(Integer limit, String cursor) {
        try {
            return this.prepareListBookingCustomAttributeDefinitionsRequest(limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListBookingCustomAttributeDefinitionsResponse, ApiException> prepareListBookingCustomAttributeDefinitionsRequest(Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/custom-attribute-definitions").queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListBookingCustomAttributeDefinitionsResponse)ApiHelper.deserialize((String)response, ListBookingCustomAttributeDefinitionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateBookingCustomAttributeDefinitionResponse createBookingCustomAttributeDefinition(CreateBookingCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (CreateBookingCustomAttributeDefinitionResponse)this.prepareCreateBookingCustomAttributeDefinitionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateBookingCustomAttributeDefinitionResponse> createBookingCustomAttributeDefinitionAsync(CreateBookingCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareCreateBookingCustomAttributeDefinitionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateBookingCustomAttributeDefinitionResponse, ApiException> prepareCreateBookingCustomAttributeDefinitionRequest(CreateBookingCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/custom-attribute-definitions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateBookingCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, CreateBookingCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteBookingCustomAttributeDefinitionResponse deleteBookingCustomAttributeDefinition(String key) throws ApiException, IOException {
        return (DeleteBookingCustomAttributeDefinitionResponse)this.prepareDeleteBookingCustomAttributeDefinitionRequest(key).execute();
    }

    @Override
    public CompletableFuture<DeleteBookingCustomAttributeDefinitionResponse> deleteBookingCustomAttributeDefinitionAsync(String key) {
        try {
            return this.prepareDeleteBookingCustomAttributeDefinitionRequest(key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteBookingCustomAttributeDefinitionResponse, ApiException> prepareDeleteBookingCustomAttributeDefinitionRequest(String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/custom-attribute-definitions/{key}").templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteBookingCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, DeleteBookingCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveBookingCustomAttributeDefinitionResponse retrieveBookingCustomAttributeDefinition(String key, Integer version) throws ApiException, IOException {
        return (RetrieveBookingCustomAttributeDefinitionResponse)this.prepareRetrieveBookingCustomAttributeDefinitionRequest(key, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveBookingCustomAttributeDefinitionResponse> retrieveBookingCustomAttributeDefinitionAsync(String key, Integer version) {
        try {
            return this.prepareRetrieveBookingCustomAttributeDefinitionRequest(key, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveBookingCustomAttributeDefinitionResponse, ApiException> prepareRetrieveBookingCustomAttributeDefinitionRequest(String key, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/custom-attribute-definitions/{key}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveBookingCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, RetrieveBookingCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateBookingCustomAttributeDefinitionResponse updateBookingCustomAttributeDefinition(String key, UpdateBookingCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (UpdateBookingCustomAttributeDefinitionResponse)this.prepareUpdateBookingCustomAttributeDefinitionRequest(key, body).execute();
    }

    @Override
    public CompletableFuture<UpdateBookingCustomAttributeDefinitionResponse> updateBookingCustomAttributeDefinitionAsync(String key, UpdateBookingCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareUpdateBookingCustomAttributeDefinitionRequest(key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateBookingCustomAttributeDefinitionResponse, ApiException> prepareUpdateBookingCustomAttributeDefinitionRequest(String key, UpdateBookingCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/custom-attribute-definitions/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateBookingCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, UpdateBookingCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkDeleteBookingCustomAttributesResponse bulkDeleteBookingCustomAttributes(BulkDeleteBookingCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkDeleteBookingCustomAttributesResponse)this.prepareBulkDeleteBookingCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkDeleteBookingCustomAttributesResponse> bulkDeleteBookingCustomAttributesAsync(BulkDeleteBookingCustomAttributesRequest body) {
        try {
            return this.prepareBulkDeleteBookingCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkDeleteBookingCustomAttributesResponse, ApiException> prepareBulkDeleteBookingCustomAttributesRequest(BulkDeleteBookingCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/custom-attributes/bulk-delete").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkDeleteBookingCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkDeleteBookingCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkUpsertBookingCustomAttributesResponse bulkUpsertBookingCustomAttributes(BulkUpsertBookingCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkUpsertBookingCustomAttributesResponse)this.prepareBulkUpsertBookingCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkUpsertBookingCustomAttributesResponse> bulkUpsertBookingCustomAttributesAsync(BulkUpsertBookingCustomAttributesRequest body) {
        try {
            return this.prepareBulkUpsertBookingCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkUpsertBookingCustomAttributesResponse, ApiException> prepareBulkUpsertBookingCustomAttributesRequest(BulkUpsertBookingCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/custom-attributes/bulk-upsert").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkUpsertBookingCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkUpsertBookingCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListBookingCustomAttributesResponse listBookingCustomAttributes(String bookingId, Integer limit, String cursor, Boolean withDefinitions) throws ApiException, IOException {
        return (ListBookingCustomAttributesResponse)this.prepareListBookingCustomAttributesRequest(bookingId, limit, cursor, withDefinitions).execute();
    }

    @Override
    public CompletableFuture<ListBookingCustomAttributesResponse> listBookingCustomAttributesAsync(String bookingId, Integer limit, String cursor, Boolean withDefinitions) {
        try {
            return this.prepareListBookingCustomAttributesRequest(bookingId, limit, cursor, withDefinitions).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListBookingCustomAttributesResponse, ApiException> prepareListBookingCustomAttributesRequest(String bookingId, Integer limit, String cursor, Boolean withDefinitions) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/{booking_id}/custom-attributes").queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("with_definitions").value((Object)(withDefinitions != null ? withDefinitions : false)).isRequired(false)).templateParam(param -> param.key("booking_id").value((Object)bookingId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListBookingCustomAttributesResponse)ApiHelper.deserialize((String)response, ListBookingCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteBookingCustomAttributeResponse deleteBookingCustomAttribute(String bookingId, String key) throws ApiException, IOException {
        return (DeleteBookingCustomAttributeResponse)this.prepareDeleteBookingCustomAttributeRequest(bookingId, key).execute();
    }

    @Override
    public CompletableFuture<DeleteBookingCustomAttributeResponse> deleteBookingCustomAttributeAsync(String bookingId, String key) {
        try {
            return this.prepareDeleteBookingCustomAttributeRequest(bookingId, key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteBookingCustomAttributeResponse, ApiException> prepareDeleteBookingCustomAttributeRequest(String bookingId, String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/{booking_id}/custom-attributes/{key}").templateParam(param -> param.key("booking_id").value((Object)bookingId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteBookingCustomAttributeResponse)ApiHelper.deserialize((String)response, DeleteBookingCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveBookingCustomAttributeResponse retrieveBookingCustomAttribute(String bookingId, String key, Boolean withDefinition, Integer version) throws ApiException, IOException {
        return (RetrieveBookingCustomAttributeResponse)this.prepareRetrieveBookingCustomAttributeRequest(bookingId, key, withDefinition, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveBookingCustomAttributeResponse> retrieveBookingCustomAttributeAsync(String bookingId, String key, Boolean withDefinition, Integer version) {
        try {
            return this.prepareRetrieveBookingCustomAttributeRequest(bookingId, key, withDefinition, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveBookingCustomAttributeResponse, ApiException> prepareRetrieveBookingCustomAttributeRequest(String bookingId, String key, Boolean withDefinition, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/{booking_id}/custom-attributes/{key}").queryParam(param -> param.key("with_definition").value((Object)(withDefinition != null ? withDefinition : false)).isRequired(false)).queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("booking_id").value((Object)bookingId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveBookingCustomAttributeResponse)ApiHelper.deserialize((String)response, RetrieveBookingCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpsertBookingCustomAttributeResponse upsertBookingCustomAttribute(String bookingId, String key, UpsertBookingCustomAttributeRequest body) throws ApiException, IOException {
        return (UpsertBookingCustomAttributeResponse)this.prepareUpsertBookingCustomAttributeRequest(bookingId, key, body).execute();
    }

    @Override
    public CompletableFuture<UpsertBookingCustomAttributeResponse> upsertBookingCustomAttributeAsync(String bookingId, String key, UpsertBookingCustomAttributeRequest body) {
        try {
            return this.prepareUpsertBookingCustomAttributeRequest(bookingId, key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpsertBookingCustomAttributeResponse, ApiException> prepareUpsertBookingCustomAttributeRequest(String bookingId, String key, UpsertBookingCustomAttributeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/{booking_id}/custom-attributes/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("booking_id").value((Object)bookingId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpsertBookingCustomAttributeResponse)ApiHelper.deserialize((String)response, UpsertBookingCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

