/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CardsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateCardRequest;
import com.squareup.square.models.CreateCardResponse;
import com.squareup.square.models.DisableCardResponse;
import com.squareup.square.models.ListCardsResponse;
import com.squareup.square.models.RetrieveCardResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultCardsApi
extends BaseApi
implements CardsApi {
    public DefaultCardsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListCardsResponse listCards(String cursor, String customerId, Boolean includeDisabled, String referenceId, String sortOrder) throws ApiException, IOException {
        return (ListCardsResponse)this.prepareListCardsRequest(cursor, customerId, includeDisabled, referenceId, sortOrder).execute();
    }

    @Override
    public CompletableFuture<ListCardsResponse> listCardsAsync(String cursor, String customerId, Boolean includeDisabled, String referenceId, String sortOrder) {
        try {
            return this.prepareListCardsRequest(cursor, customerId, includeDisabled, referenceId, sortOrder).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCardsResponse, ApiException> prepareListCardsRequest(String cursor, String customerId, Boolean includeDisabled, String referenceId, String sortOrder) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/cards").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("customer_id").value((Object)customerId).isRequired(false)).queryParam(param -> param.key("include_disabled").value((Object)(includeDisabled != null ? includeDisabled : false)).isRequired(false)).queryParam(param -> param.key("reference_id").value((Object)referenceId).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCardsResponse)ApiHelper.deserialize((String)response, ListCardsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateCardResponse createCard(CreateCardRequest body) throws ApiException, IOException {
        return (CreateCardResponse)this.prepareCreateCardRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateCardResponse> createCardAsync(CreateCardRequest body) {
        try {
            return this.prepareCreateCardRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateCardResponse, ApiException> prepareCreateCardRequest(CreateCardRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/cards").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateCardResponse)ApiHelper.deserialize((String)response, CreateCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCardResponse retrieveCard(String cardId) throws ApiException, IOException {
        return (RetrieveCardResponse)this.prepareRetrieveCardRequest(cardId).execute();
    }

    @Override
    public CompletableFuture<RetrieveCardResponse> retrieveCardAsync(String cardId) {
        try {
            return this.prepareRetrieveCardRequest(cardId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCardResponse, ApiException> prepareRetrieveCardRequest(String cardId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/cards/{card_id}").templateParam(param -> param.key("card_id").value((Object)cardId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCardResponse)ApiHelper.deserialize((String)response, RetrieveCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DisableCardResponse disableCard(String cardId) throws ApiException, IOException {
        return (DisableCardResponse)this.prepareDisableCardRequest(cardId).execute();
    }

    @Override
    public CompletableFuture<DisableCardResponse> disableCardAsync(String cardId) {
        try {
            return this.prepareDisableCardRequest(cardId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DisableCardResponse, ApiException> prepareDisableCardRequest(String cardId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/cards/{card_id}/disable").templateParam(param -> param.key("card_id").value((Object)cardId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DisableCardResponse)ApiHelper.deserialize((String)response, DisableCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

