/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CashDrawersApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.ListCashDrawerShiftEventsResponse;
import com.squareup.square.models.ListCashDrawerShiftsResponse;
import com.squareup.square.models.RetrieveCashDrawerShiftResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultCashDrawersApi
extends BaseApi
implements CashDrawersApi {
    public DefaultCashDrawersApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListCashDrawerShiftsResponse listCashDrawerShifts(String locationId, String sortOrder, String beginTime, String endTime, Integer limit, String cursor) throws ApiException, IOException {
        return (ListCashDrawerShiftsResponse)this.prepareListCashDrawerShiftsRequest(locationId, sortOrder, beginTime, endTime, limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListCashDrawerShiftsResponse> listCashDrawerShiftsAsync(String locationId, String sortOrder, String beginTime, String endTime, Integer limit, String cursor) {
        try {
            return this.prepareListCashDrawerShiftsRequest(locationId, sortOrder, beginTime, endTime, limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCashDrawerShiftsResponse, ApiException> prepareListCashDrawerShiftsRequest(String locationId, String sortOrder, String beginTime, String endTime, Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/cash-drawers/shifts").queryParam(param -> param.key("location_id").value((Object)locationId)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("begin_time").value((Object)beginTime).isRequired(false)).queryParam(param -> param.key("end_time").value((Object)endTime).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCashDrawerShiftsResponse)ApiHelper.deserialize((String)response, ListCashDrawerShiftsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCashDrawerShiftResponse retrieveCashDrawerShift(String locationId, String shiftId) throws ApiException, IOException {
        return (RetrieveCashDrawerShiftResponse)this.prepareRetrieveCashDrawerShiftRequest(locationId, shiftId).execute();
    }

    @Override
    public CompletableFuture<RetrieveCashDrawerShiftResponse> retrieveCashDrawerShiftAsync(String locationId, String shiftId) {
        try {
            return this.prepareRetrieveCashDrawerShiftRequest(locationId, shiftId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCashDrawerShiftResponse, ApiException> prepareRetrieveCashDrawerShiftRequest(String locationId, String shiftId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/cash-drawers/shifts/{shift_id}").queryParam(param -> param.key("location_id").value((Object)locationId)).templateParam(param -> param.key("shift_id").value((Object)shiftId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCashDrawerShiftResponse)ApiHelper.deserialize((String)response, RetrieveCashDrawerShiftResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListCashDrawerShiftEventsResponse listCashDrawerShiftEvents(String locationId, String shiftId, Integer limit, String cursor) throws ApiException, IOException {
        return (ListCashDrawerShiftEventsResponse)this.prepareListCashDrawerShiftEventsRequest(locationId, shiftId, limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListCashDrawerShiftEventsResponse> listCashDrawerShiftEventsAsync(String locationId, String shiftId, Integer limit, String cursor) {
        try {
            return this.prepareListCashDrawerShiftEventsRequest(locationId, shiftId, limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCashDrawerShiftEventsResponse, ApiException> prepareListCashDrawerShiftEventsRequest(String locationId, String shiftId, Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/cash-drawers/shifts/{shift_id}/events").queryParam(param -> param.key("location_id").value((Object)locationId)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).templateParam(param -> param.key("shift_id").value((Object)shiftId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCashDrawerShiftEventsResponse)ApiHelper.deserialize((String)response, ListCashDrawerShiftEventsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

