/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CatalogApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BatchDeleteCatalogObjectsRequest;
import com.squareup.square.models.BatchDeleteCatalogObjectsResponse;
import com.squareup.square.models.BatchRetrieveCatalogObjectsRequest;
import com.squareup.square.models.BatchRetrieveCatalogObjectsResponse;
import com.squareup.square.models.BatchUpsertCatalogObjectsRequest;
import com.squareup.square.models.BatchUpsertCatalogObjectsResponse;
import com.squareup.square.models.CatalogInfoResponse;
import com.squareup.square.models.CreateCatalogImageRequest;
import com.squareup.square.models.CreateCatalogImageResponse;
import com.squareup.square.models.DeleteCatalogObjectResponse;
import com.squareup.square.models.ListCatalogResponse;
import com.squareup.square.models.RetrieveCatalogObjectResponse;
import com.squareup.square.models.SearchCatalogItemsRequest;
import com.squareup.square.models.SearchCatalogItemsResponse;
import com.squareup.square.models.SearchCatalogObjectsRequest;
import com.squareup.square.models.SearchCatalogObjectsResponse;
import com.squareup.square.models.UpdateCatalogImageRequest;
import com.squareup.square.models.UpdateCatalogImageResponse;
import com.squareup.square.models.UpdateItemModifierListsRequest;
import com.squareup.square.models.UpdateItemModifierListsResponse;
import com.squareup.square.models.UpdateItemTaxesRequest;
import com.squareup.square.models.UpdateItemTaxesResponse;
import com.squareup.square.models.UpsertCatalogObjectRequest;
import com.squareup.square.models.UpsertCatalogObjectResponse;
import com.squareup.square.utilities.FileWrapper;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.MutliPartRequestType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultCatalogApi
extends BaseApi
implements CatalogApi {
    public DefaultCatalogApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public BatchDeleteCatalogObjectsResponse batchDeleteCatalogObjects(BatchDeleteCatalogObjectsRequest body) throws ApiException, IOException {
        return (BatchDeleteCatalogObjectsResponse)this.prepareBatchDeleteCatalogObjectsRequest(body).execute();
    }

    @Override
    public CompletableFuture<BatchDeleteCatalogObjectsResponse> batchDeleteCatalogObjectsAsync(BatchDeleteCatalogObjectsRequest body) {
        try {
            return this.prepareBatchDeleteCatalogObjectsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BatchDeleteCatalogObjectsResponse, ApiException> prepareBatchDeleteCatalogObjectsRequest(BatchDeleteCatalogObjectsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/batch-delete").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BatchDeleteCatalogObjectsResponse)ApiHelper.deserialize((String)response, BatchDeleteCatalogObjectsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BatchRetrieveCatalogObjectsResponse batchRetrieveCatalogObjects(BatchRetrieveCatalogObjectsRequest body) throws ApiException, IOException {
        return (BatchRetrieveCatalogObjectsResponse)this.prepareBatchRetrieveCatalogObjectsRequest(body).execute();
    }

    @Override
    public CompletableFuture<BatchRetrieveCatalogObjectsResponse> batchRetrieveCatalogObjectsAsync(BatchRetrieveCatalogObjectsRequest body) {
        try {
            return this.prepareBatchRetrieveCatalogObjectsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BatchRetrieveCatalogObjectsResponse, ApiException> prepareBatchRetrieveCatalogObjectsRequest(BatchRetrieveCatalogObjectsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/batch-retrieve").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BatchRetrieveCatalogObjectsResponse)ApiHelper.deserialize((String)response, BatchRetrieveCatalogObjectsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BatchUpsertCatalogObjectsResponse batchUpsertCatalogObjects(BatchUpsertCatalogObjectsRequest body) throws ApiException, IOException {
        return (BatchUpsertCatalogObjectsResponse)this.prepareBatchUpsertCatalogObjectsRequest(body).execute();
    }

    @Override
    public CompletableFuture<BatchUpsertCatalogObjectsResponse> batchUpsertCatalogObjectsAsync(BatchUpsertCatalogObjectsRequest body) {
        try {
            return this.prepareBatchUpsertCatalogObjectsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BatchUpsertCatalogObjectsResponse, ApiException> prepareBatchUpsertCatalogObjectsRequest(BatchUpsertCatalogObjectsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/batch-upsert").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BatchUpsertCatalogObjectsResponse)ApiHelper.deserialize((String)response, BatchUpsertCatalogObjectsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateCatalogImageResponse createCatalogImage(CreateCatalogImageRequest request, FileWrapper imageFile) throws ApiException, IOException {
        return (CreateCatalogImageResponse)this.prepareCreateCatalogImageRequest(request, imageFile).execute();
    }

    @Override
    public CompletableFuture<CreateCatalogImageResponse> createCatalogImageAsync(CreateCatalogImageRequest request, FileWrapper imageFile) {
        try {
            return this.prepareCreateCatalogImageRequest(request, imageFile).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateCatalogImageResponse, ApiException> prepareCreateCatalogImageRequest(CreateCatalogImageRequest request, FileWrapper imageFile) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/images").formParam(param -> param.key("request").value((Object)request).multipartSerializer(() -> ApiHelper.serialize((Object)request)).multiPartRequestType(MutliPartRequestType.MULTI_PART).multipartHeaders("Content-Type", "application/json; charset=utf-8")).formParam(param -> param.key("image_file").value((Object)imageFile).multiPartRequestType(MutliPartRequestType.MULTI_PART_FILE).multipartHeaders("Content-Type", "image/jpeg")).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateCatalogImageResponse)ApiHelper.deserialize((String)response, CreateCatalogImageResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateCatalogImageResponse updateCatalogImage(String imageId, UpdateCatalogImageRequest request, FileWrapper imageFile) throws ApiException, IOException {
        return (UpdateCatalogImageResponse)this.prepareUpdateCatalogImageRequest(imageId, request, imageFile).execute();
    }

    @Override
    public CompletableFuture<UpdateCatalogImageResponse> updateCatalogImageAsync(String imageId, UpdateCatalogImageRequest request, FileWrapper imageFile) {
        try {
            return this.prepareUpdateCatalogImageRequest(imageId, request, imageFile).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateCatalogImageResponse, ApiException> prepareUpdateCatalogImageRequest(String imageId, UpdateCatalogImageRequest request, FileWrapper imageFile) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/images/{image_id}").formParam(param -> param.key("request").value((Object)request).multipartSerializer(() -> ApiHelper.serialize((Object)request)).multiPartRequestType(MutliPartRequestType.MULTI_PART).multipartHeaders("Content-Type", "application/json; charset=utf-8")).formParam(param -> param.key("image_file").value((Object)imageFile).multiPartRequestType(MutliPartRequestType.MULTI_PART_FILE).multipartHeaders("Content-Type", "image/jpeg")).templateParam(param -> param.key("image_id").value((Object)imageId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateCatalogImageResponse)ApiHelper.deserialize((String)response, UpdateCatalogImageResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CatalogInfoResponse catalogInfo() throws ApiException, IOException {
        return (CatalogInfoResponse)this.prepareCatalogInfoRequest().execute();
    }

    @Override
    public CompletableFuture<CatalogInfoResponse> catalogInfoAsync() {
        try {
            return this.prepareCatalogInfoRequest().executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CatalogInfoResponse, ApiException> prepareCatalogInfoRequest() throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/info").headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CatalogInfoResponse)ApiHelper.deserialize((String)response, CatalogInfoResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListCatalogResponse listCatalog(String cursor, String types, Long catalogVersion) throws ApiException, IOException {
        return (ListCatalogResponse)this.prepareListCatalogRequest(cursor, types, catalogVersion).execute();
    }

    @Override
    public CompletableFuture<ListCatalogResponse> listCatalogAsync(String cursor, String types, Long catalogVersion) {
        try {
            return this.prepareListCatalogRequest(cursor, types, catalogVersion).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCatalogResponse, ApiException> prepareListCatalogRequest(String cursor, String types, Long catalogVersion) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/list").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("types").value((Object)types).isRequired(false)).queryParam(param -> param.key("catalog_version").value((Object)catalogVersion).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCatalogResponse)ApiHelper.deserialize((String)response, ListCatalogResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpsertCatalogObjectResponse upsertCatalogObject(UpsertCatalogObjectRequest body) throws ApiException, IOException {
        return (UpsertCatalogObjectResponse)this.prepareUpsertCatalogObjectRequest(body).execute();
    }

    @Override
    public CompletableFuture<UpsertCatalogObjectResponse> upsertCatalogObjectAsync(UpsertCatalogObjectRequest body) {
        try {
            return this.prepareUpsertCatalogObjectRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpsertCatalogObjectResponse, ApiException> prepareUpsertCatalogObjectRequest(UpsertCatalogObjectRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/object").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpsertCatalogObjectResponse)ApiHelper.deserialize((String)response, UpsertCatalogObjectResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteCatalogObjectResponse deleteCatalogObject(String objectId) throws ApiException, IOException {
        return (DeleteCatalogObjectResponse)this.prepareDeleteCatalogObjectRequest(objectId).execute();
    }

    @Override
    public CompletableFuture<DeleteCatalogObjectResponse> deleteCatalogObjectAsync(String objectId) {
        try {
            return this.prepareDeleteCatalogObjectRequest(objectId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteCatalogObjectResponse, ApiException> prepareDeleteCatalogObjectRequest(String objectId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/object/{object_id}").templateParam(param -> param.key("object_id").value((Object)objectId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteCatalogObjectResponse)ApiHelper.deserialize((String)response, DeleteCatalogObjectResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCatalogObjectResponse retrieveCatalogObject(String objectId, Boolean includeRelatedObjects, Long catalogVersion, Boolean includeCategoryPathToRoot) throws ApiException, IOException {
        return (RetrieveCatalogObjectResponse)this.prepareRetrieveCatalogObjectRequest(objectId, includeRelatedObjects, catalogVersion, includeCategoryPathToRoot).execute();
    }

    @Override
    public CompletableFuture<RetrieveCatalogObjectResponse> retrieveCatalogObjectAsync(String objectId, Boolean includeRelatedObjects, Long catalogVersion, Boolean includeCategoryPathToRoot) {
        try {
            return this.prepareRetrieveCatalogObjectRequest(objectId, includeRelatedObjects, catalogVersion, includeCategoryPathToRoot).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCatalogObjectResponse, ApiException> prepareRetrieveCatalogObjectRequest(String objectId, Boolean includeRelatedObjects, Long catalogVersion, Boolean includeCategoryPathToRoot) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/object/{object_id}").queryParam(param -> param.key("include_related_objects").value((Object)(includeRelatedObjects != null ? includeRelatedObjects : false)).isRequired(false)).queryParam(param -> param.key("catalog_version").value((Object)catalogVersion).isRequired(false)).queryParam(param -> param.key("include_category_path_to_root").value((Object)(includeCategoryPathToRoot != null ? includeCategoryPathToRoot : false)).isRequired(false)).templateParam(param -> param.key("object_id").value((Object)objectId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCatalogObjectResponse)ApiHelper.deserialize((String)response, RetrieveCatalogObjectResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchCatalogObjectsResponse searchCatalogObjects(SearchCatalogObjectsRequest body) throws ApiException, IOException {
        return (SearchCatalogObjectsResponse)this.prepareSearchCatalogObjectsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchCatalogObjectsResponse> searchCatalogObjectsAsync(SearchCatalogObjectsRequest body) {
        try {
            return this.prepareSearchCatalogObjectsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchCatalogObjectsResponse, ApiException> prepareSearchCatalogObjectsRequest(SearchCatalogObjectsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchCatalogObjectsResponse)ApiHelper.deserialize((String)response, SearchCatalogObjectsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchCatalogItemsResponse searchCatalogItems(SearchCatalogItemsRequest body) throws ApiException, IOException {
        return (SearchCatalogItemsResponse)this.prepareSearchCatalogItemsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchCatalogItemsResponse> searchCatalogItemsAsync(SearchCatalogItemsRequest body) {
        try {
            return this.prepareSearchCatalogItemsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchCatalogItemsResponse, ApiException> prepareSearchCatalogItemsRequest(SearchCatalogItemsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/search-catalog-items").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchCatalogItemsResponse)ApiHelper.deserialize((String)response, SearchCatalogItemsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateItemModifierListsResponse updateItemModifierLists(UpdateItemModifierListsRequest body) throws ApiException, IOException {
        return (UpdateItemModifierListsResponse)this.prepareUpdateItemModifierListsRequest(body).execute();
    }

    @Override
    public CompletableFuture<UpdateItemModifierListsResponse> updateItemModifierListsAsync(UpdateItemModifierListsRequest body) {
        try {
            return this.prepareUpdateItemModifierListsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateItemModifierListsResponse, ApiException> prepareUpdateItemModifierListsRequest(UpdateItemModifierListsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/update-item-modifier-lists").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateItemModifierListsResponse)ApiHelper.deserialize((String)response, UpdateItemModifierListsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateItemTaxesResponse updateItemTaxes(UpdateItemTaxesRequest body) throws ApiException, IOException {
        return (UpdateItemTaxesResponse)this.prepareUpdateItemTaxesRequest(body).execute();
    }

    @Override
    public CompletableFuture<UpdateItemTaxesResponse> updateItemTaxesAsync(UpdateItemTaxesRequest body) {
        try {
            return this.prepareUpdateItemTaxesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateItemTaxesResponse, ApiException> prepareUpdateItemTaxesRequest(UpdateItemTaxesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/catalog/update-item-taxes").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateItemTaxesResponse)ApiHelper.deserialize((String)response, UpdateItemTaxesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

